/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.properties;

import com.atlassian.tunnel.properties.TunnelProperties;
import java.net.InetAddress;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTunnelProperties
implements TunnelProperties {
    private static final Logger log = LoggerFactory.getLogger(DefaultTunnelProperties.class);
    static final String TUNNEL_SERVICE_ENDPOINT_DEFAULT = "wss://tunnel.services.atlassian.com";
    static final String UPSTREAM_HOST_URL_DEFAULT = "http://127.0.0.1:8093";
    static final long START_WAIT_TIME_DEFAULT = Duration.ofSeconds(10L).toMillis();
    static final long CONFIG_REFRESH_INTERVAL_DEFAULT = Duration.ofMinutes(1L).toMillis();
    static final long CONFIG_REFRESH_INITIAL_WAIT_DEFAULT = Duration.ofMinutes(1L).toMillis();
    static final long CLUSTER_SYNC_INTERVAL_DEFAULT = Duration.ofHours(1L).toMillis();
    static final int MAX_RETRIES_DEFAULT = Integer.MAX_VALUE;

    @Override
    public String getTunnelServiceUrl() {
        return System.getProperty("secure.tunnel.service.endpoint", TUNNEL_SERVICE_ENDPOINT_DEFAULT);
    }

    @Override
    public String getUpstreamHostUrl() {
        Integer port = Integer.getInteger("secure.tunnel.upstream.port");
        return this.formatUpstreamUrl(port);
    }

    @Override
    public long getStartWaitTime() {
        return Long.getLong("secure.tunnel.start.wait", START_WAIT_TIME_DEFAULT);
    }

    @Override
    public long getConfigRefreshInterval() {
        return Long.getLong("secure.tunnel.config.refresh.interval", CONFIG_REFRESH_INTERVAL_DEFAULT);
    }

    @Override
    public long getConfigRefreshInitialWait() {
        return Long.getLong("secure.tunnel.config.refresh.initial.wait", CONFIG_REFRESH_INITIAL_WAIT_DEFAULT);
    }

    @Override
    public long getClusterSyncInterval() {
        return Long.getLong("secure.tunnel.cluster.sync.interval", CLUSTER_SYNC_INTERVAL_DEFAULT);
    }

    @Override
    public int getMaxRetries() {
        return Integer.getInteger("secure.tunnel.start.retries", Integer.MAX_VALUE);
    }

    protected String formatUpstreamUrl(Integer upstreamPort) {
        if (upstreamPort == null) {
            log.trace("Using default upstream URL {} ", (Object)UPSTREAM_HOST_URL_DEFAULT);
            return UPSTREAM_HOST_URL_DEFAULT;
        }
        return String.format("http://%s:%d", InetAddress.getLoopbackAddress().getHostAddress(), upstreamPort);
    }
}

