/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

public enum TunnelUnauthorizedReason {
    HEADER_MALFORMED("Authorization header malformed or not provided"),
    FAILED_TO_GET_TUNNEL("Failed to get tunnel for hostname"),
    INVALID_TOKEN("Token did not match. Permission is denied"),
    OTHER("Unknown error");

    private final String displayName;

    private TunnelUnauthorizedReason(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static TunnelUnauthorizedReason fromDisplayName(String displayName) {
        if (displayName.equals(TunnelUnauthorizedReason.HEADER_MALFORMED.displayName)) {
            return HEADER_MALFORMED;
        }
        if (displayName.equals(TunnelUnauthorizedReason.FAILED_TO_GET_TUNNEL.displayName)) {
            return FAILED_TO_GET_TUNNEL;
        }
        if (displayName.equals(TunnelUnauthorizedReason.INVALID_TOKEN.displayName)) {
            return INVALID_TOKEN;
        }
        return OTHER;
    }
}

