/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.monitoring;

import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.monitoring.TunnelConnection;
import com.atlassian.tunnel.monitoring.dao.TunnelConnectionDao;
import com.atlassian.tunnel.process.TunnelProcessState;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelConnectionService {
    private static final Logger log = LoggerFactory.getLogger(TunnelConnectionService.class);
    private static final String NOT_CLUSTERED_NODE_ID_VALUE = "NOT_CLUSTERED";
    private final TunnelConnectionDao tunnelConnectionDao;
    private final NodeIdProvider nodeIdProvider;

    public boolean isTunnelConnected() {
        return this.getTunnelConnections().stream().anyMatch(tunnelConnection -> tunnelConnection.getNodeId().equals(this.getNodeId()) && TunnelProcessState.Status.RUNNING.equals((Object)tunnelConnection.getStatus()));
    }

    public List<TunnelConnection> getTunnelConnections() {
        this.syncTunnelConnectionsToClusterState();
        List<TunnelConnection> tunnelConnections = this.tunnelConnectionDao.getTunnelConnections();
        log.trace("Retrieved tunnel connections from database: {}", tunnelConnections);
        return tunnelConnections;
    }

    public void updateLocalTunnelConnection(TunnelProcessState newState) {
        TunnelConnection updatedTunnelConnection = TunnelConnection.builder().nodeId(this.getNodeId()).status(newState.getStatus()).retryCount(newState.getRetryCount()).build();
        this.tunnelConnectionDao.saveTunnelConnection(updatedTunnelConnection);
        log.info("Successfully updated tunnel connection for node with ID {}", (Object)updatedTunnelConnection.getNodeId());
        log.debug("Tunnel connection updated to: {}", (Object)updatedTunnelConnection);
    }

    private String getNodeId() {
        return this.nodeIdProvider.getLocalNodeId().orElse(NOT_CLUSTERED_NODE_ID_VALUE);
    }

    public void deleteTunnelConnections() {
        log.debug("Removing all tunnel connections from database");
        this.tunnelConnectionDao.deleteAllTunnelConnections();
    }

    public void syncTunnelConnectionsToClusterState() {
        Set<String> clusterNodeIds = this.nodeIdProvider.getClusterNodeIds();
        if (!clusterNodeIds.isEmpty()) {
            Set tunnelConnectionNodeIds = this.tunnelConnectionDao.getTunnelConnections().stream().map(TunnelConnection::getNodeId).collect(Collectors.toSet());
            if (clusterNodeIds.equals(tunnelConnectionNodeIds)) {
                log.debug("Tunnel Connections are in sync with cluster state, skipping sync");
            } else {
                log.info("Synchronising Tunnel Connections to cluster state");
                Sets.SetView nodeIdsOfTunnelConnectionsToDelete = Sets.difference(tunnelConnectionNodeIds, clusterNodeIds);
                nodeIdsOfTunnelConnectionsToDelete.forEach(this.tunnelConnectionDao::deleteTunnelConnectionByNodeId);
            }
        } else {
            log.trace("Skipping Tunnel Connection cluster sync as not clustered");
        }
    }

    @Generated
    public TunnelConnectionService(TunnelConnectionDao tunnelConnectionDao, NodeIdProvider nodeIdProvider) {
        this.tunnelConnectionDao = tunnelConnectionDao;
        this.nodeIdProvider = nodeIdProvider;
    }
}

