/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.scheduled;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.configuration.rest.external.TunnelStatusCheckResponse;
import com.atlassian.tunnel.configuration.rest.external.TunnelStatusCheckService;
import com.atlassian.tunnel.configuration.scheduled.TunnelRefreshJob;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.process.event.TunnelRoutingUnavailableEvent;
import com.atlassian.tunnel.scheduled.TunnelScheduledJob;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelStatusCheckJob
implements TunnelScheduledJob {
    private static final Logger log = LoggerFactory.getLogger(TunnelStatusCheckJob.class);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)TunnelStatusCheckJob.class.getName());
    static final JobId JOB_ID = JobId.of((String)TunnelStatusCheckJob.class.getSimpleName());
    private final Clock clock;
    private final TunnelStatusCheckService tunnelStatusCheckService;
    private final TunnelService tunnelService;
    private final TunnelConnectionService tunnelConnectionService;
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;

    @Override
    public void schedule() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new TunnelRefreshJobRunner());
        this.scheduleJob(this.createJobConfig(TunnelStatusCheckService.DEFAULT_INTERVAL, null));
    }

    @Override
    public void unschedule() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private JobConfig createJobConfig(Duration interval, Date firstRunTime) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)interval.toMillis(), (Date)firstRunTime));
    }

    private void scheduleJob(JobConfig jobConfig) {
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Could not schedule job {}", (Object)TunnelRefreshJob.class.getName());
            throw new RuntimeException(e);
        }
    }

    @Generated
    public TunnelStatusCheckJob(Clock clock, TunnelStatusCheckService tunnelStatusCheckService, TunnelService tunnelService, TunnelConnectionService tunnelConnectionService, EventPublisher eventPublisher, SchedulerService schedulerService) {
        this.clock = clock;
        this.tunnelStatusCheckService = tunnelStatusCheckService;
        this.tunnelService = tunnelService;
        this.tunnelConnectionService = tunnelConnectionService;
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
    }

    public class TunnelRefreshJobRunner
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            this.checkTunnelServiceStatus();
            return JobRunnerResponse.success();
        }

        private void checkTunnelServiceStatus() {
            log.trace("{} running", (Object)this.getClass().getName());
            try {
                TunnelStatusCheckJob.this.tunnelService.getTunnel().filter(tunnel -> TunnelStatusCheckJob.this.tunnelConnectionService.isTunnelConnected()).map(tunnel -> {
                    TunnelStatusCheckResponse tunnelStatusCheckResponse = TunnelStatusCheckJob.this.tunnelStatusCheckService.getResponse((Tunnel)tunnel);
                    if (TunnelStatusCheckResponse.Status.UNAVAILABLE == tunnelStatusCheckResponse.getStatus()) {
                        TunnelStatusCheckJob.this.eventPublisher.publish((Object)new TunnelRoutingUnavailableEvent());
                    }
                    return tunnelStatusCheckResponse.getCheckInterval();
                }).ifPresent(nextInterval -> TunnelStatusCheckJob.this.scheduleJob(TunnelStatusCheckJob.this.createJobConfig((Duration)nextInterval, Date.from(TunnelStatusCheckJob.this.clock.instant().plus(nextInterval.toMillis(), ChronoUnit.MILLIS)))));
            }
            catch (Exception e) {
                log.error("Error getting status of tunnel: {}", (Object)e.getMessage());
            }
            log.trace("{} completed", (Object)this.getClass().getName());
        }
    }
}

