/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.CrowdTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.CrowdNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.SeraphRedirectsLoopPreventer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={CrowdOnly.class})
public class CrowdConfiguration {
    @Bean
    public ClusterService clusterService() {
        return OsgiServices.importOsgiService(ClusterService.class);
    }

    @Bean
    public NodeIdProvider crowdNodeIdProvider(ClusterService clusterService) {
        return new CrowdNodeIdProvider(clusterService);
    }

    @Bean
    public RedirectsLoopPreventer seraphRedirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public TunnelProperties tunnelProperties() {
        return new DefaultTunnelProperties();
    }

    @Bean
    public AuditService crowdAuditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }

    @Bean
    public TunnelAuditService auditService(AuditService crowdAuditService, I18nResolver i18nResolver) {
        return new CrowdTunnelAuditService(crowdAuditService, i18nResolver);
    }
}

