/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

import lombok.Generated;

public final class TunnelProcessState {
    private final Status status;
    private final int retryCount;
    private final int unuathorizedRetryCount;

    public static TunnelProcessState initial() {
        return new TunnelProcessState(Status.NOT_RUNNING, 0, 0);
    }

    public TunnelProcessState incrementRetryCount() {
        return new TunnelProcessState(this.status, this.retryCount + 1, this.unuathorizedRetryCount);
    }

    public TunnelProcessState incrementUnauthorizedRetryCount() {
        return new TunnelProcessState(this.status, this.retryCount, this.unuathorizedRetryCount + 1);
    }

    public TunnelProcessState resetRetryCount() {
        return new TunnelProcessState(this.status, 0, 0);
    }

    public TunnelProcessState resetUnauthorizedRetryCount() {
        return new TunnelProcessState(this.status, this.retryCount, 0);
    }

    @Generated
    public TunnelProcessState(Status status, int retryCount, int unuathorizedRetryCount) {
        this.status = status;
        this.retryCount = retryCount;
        this.unuathorizedRetryCount = unuathorizedRetryCount;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public int getRetryCount() {
        return this.retryCount;
    }

    @Generated
    public int getUnuathorizedRetryCount() {
        return this.unuathorizedRetryCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TunnelProcessState)) {
            return false;
        }
        TunnelProcessState other = (TunnelProcessState)o;
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        if (this.getUnuathorizedRetryCount() != other.getUnuathorizedRetryCount()) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCount();
        result = result * 59 + this.getUnuathorizedRetryCount();
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TunnelProcessState(status=" + this.getStatus() + ", retryCount=" + this.getRetryCount() + ", unuathorizedRetryCount=" + this.getUnuathorizedRetryCount() + ")";
    }

    @Generated
    public TunnelProcessState withStatus(Status status) {
        return this.status == status ? this : new TunnelProcessState(status, this.retryCount, this.unuathorizedRetryCount);
    }

    public static enum Status {
        NOT_RUNNING,
        STARTING,
        RUNNING,
        RESTARTING,
        TERMINATING,
        AUTHENTICATION_FAILED;

    }
}

