/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.tunnel.process.TunnelProcessState;
import com.atlassian.tunnel.process.event.TunnelProcessStateUpdatedEvent;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelClientProcessStateManager {
    private static final Logger log = LoggerFactory.getLogger(TunnelClientProcessStateManager.class);
    private final EventPublisher eventPublisher;
    private final AtomicReference<TunnelProcessState> state = new AtomicReference<TunnelProcessState>(TunnelProcessState.initial());
    private int errorCode;

    public TunnelProcessState getState() {
        return this.state.get();
    }

    public TunnelProcessState updateState(UnaryOperator<TunnelProcessState> updateFunction) {
        TunnelProcessState previousState = this.state.get();
        TunnelProcessState newState = this.state.updateAndGet(updateFunction);
        log.debug("Updated Tunnel Process State from {} to {}", (Object)previousState, (Object)newState);
        this.eventPublisher.publish((Object)new TunnelProcessStateUpdatedEvent(previousState, newState));
        return newState;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public TunnelClientProcessStateManager(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

