/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.monitoring;

import com.atlassian.event.api.EventListener;
import com.atlassian.tunnel.analytics.TunnelClientAnalyticsEventPublisher;
import com.atlassian.tunnel.analytics.TunnelConnectedAnalyticsEvent;
import com.atlassian.tunnel.analytics.TunnelErrorAnalyticsEvent;
import com.atlassian.tunnel.analytics.TunnelReconnectedAnalyticsEvent;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.process.TunnelProcessState;
import com.atlassian.tunnel.process.event.TunnelProcessStateUpdatedEvent;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TunnelConnectionEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TunnelConnectionEventListener.class);
    private final TunnelConnectionService tunnelConnectionService;
    private final TunnelClientAnalyticsEventPublisher tunnelClientAnalyticsEventPublisher;

    public void afterPropertiesSet() {
        this.tunnelClientAnalyticsEventPublisher.register(this);
    }

    public void destroy() {
        this.tunnelClientAnalyticsEventPublisher.unregister(this);
    }

    @EventListener
    public void updateTunnelConnection(TunnelProcessStateUpdatedEvent event) {
        log.trace("Received {}: {}", (Object)TunnelProcessStateUpdatedEvent.class.getSimpleName(), (Object)event);
        this.tunnelConnectionService.updateLocalTunnelConnection(event.getNewState());
        this.publishAnalytics(event);
    }

    private void publishAnalytics(TunnelProcessStateUpdatedEvent event) {
        TunnelProcessState.Status newStatus = event.getNewState().getStatus();
        TunnelProcessState.Status previousStatus = event.getPreviousState().getStatus();
        int retryCount = event.getNewState().getRetryCount();
        if (TunnelProcessState.Status.AUTHENTICATION_FAILED == newStatus) {
            this.tunnelClientAnalyticsEventPublisher.publish(new TunnelErrorAnalyticsEvent(Response.Status.UNAUTHORIZED.getStatusCode()));
        }
        if (TunnelProcessState.Status.RESTARTING == newStatus && retryCount == 1) {
            this.tunnelClientAnalyticsEventPublisher.publish(new TunnelErrorAnalyticsEvent(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()));
        }
        if (TunnelProcessState.Status.RUNNING == newStatus) {
            if (TunnelProcessState.Status.RESTARTING == previousStatus) {
                this.tunnelClientAnalyticsEventPublisher.publish(new TunnelReconnectedAnalyticsEvent());
            } else {
                this.tunnelClientAnalyticsEventPublisher.publish(new TunnelConnectedAnalyticsEvent());
            }
        }
    }

    @Generated
    public TunnelConnectionEventListener(TunnelConnectionService tunnelConnectionService, TunnelClientAnalyticsEventPublisher tunnelClientAnalyticsEventPublisher) {
        this.tunnelConnectionService = tunnelConnectionService;
        this.tunnelClientAnalyticsEventPublisher = tunnelClientAnalyticsEventPublisher;
    }
}

