/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.rest.external;

import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.rest.external.TunnelStatusCheckResponse;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.rest.RestUtil;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelStatusCheckService {
    private static final Logger log = LoggerFactory.getLogger(TunnelStatusCheckService.class);
    public static final Duration DEFAULT_INTERVAL = Duration.ofMinutes(15L);
    static final String SERVICE_PROTOCOL_SYSTEM_PROPERTY = "tunnel.status.service.protocol";
    static final String TUNNEL_STATUS_SERVICE_PATH = "status";
    private final TunnelProperties tunnelProperties;

    public TunnelStatusCheckService(TunnelProperties tunnelProperties) {
        this.tunnelProperties = tunnelProperties;
    }

    public TunnelStatusCheckResponse getResponse(Tunnel tunnel) {
        TunnelStatusCheckResponse tunnelStatusCheckResponse;
        block8: {
            CloseableHttpClient httpClient = HttpClients.createSystem();
            try {
                tunnelStatusCheckResponse = (TunnelStatusCheckResponse)httpClient.execute((HttpUriRequest)this.createHttpGet(tunnel), response -> {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        Duration checkInterval = this.getCheckIntervalFromResponse(response);
                        return TunnelStatusCheckResponse.available(checkInterval);
                    }
                    if (statusCode == 401 || statusCode == 404) {
                        this.logResponse(response);
                        return TunnelStatusCheckResponse.unavailable();
                    }
                    this.logResponse(response);
                    return TunnelStatusCheckResponse.unknown();
                });
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.debug("Failed to make request to tunnel status service", (Throwable)e);
                    return TunnelStatusCheckResponse.unknown();
                }
            }
            httpClient.close();
        }
        return tunnelStatusCheckResponse;
    }

    private HttpGet createHttpGet(Tunnel tunnel) {
        int requestTimeout = (int)Duration.ofSeconds(Integer.getInteger("tunnel.status.service.timeout.seconds", 10).intValue()).toMillis();
        HttpGet httpGet = new HttpGet(this.getTunnelStatusServiceUrl());
        httpGet.setConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectionRequestTimeout(requestTimeout).setConnectTimeout(requestTimeout).setSocketTimeout(requestTimeout).build());
        httpGet.addHeader("Authorization", "Bearer " + tunnel.getToken());
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("x-inlets-upstream", this.getTunnelHostnameFromUpstreamDns(tunnel));
        return httpGet;
    }

    private String getTunnelStatusServiceUrl() {
        return String.format("%s://%s/%s", System.getProperty(SERVICE_PROTOCOL_SYSTEM_PROPERTY, "https"), this.getTunnelServiceHost(), TUNNEL_STATUS_SERVICE_PATH);
    }

    private String getTunnelServiceHost() {
        return URI.create(this.tunnelProperties.getTunnelServiceUrl()).getAuthority();
    }

    private String getTunnelHostnameFromUpstreamDns(Tunnel tunnel) {
        return StringUtils.substringBefore((String)URI.create(tunnel.getUpstreamDnsUrl()).getAuthority(), (String)".");
    }

    private Duration getCheckIntervalFromResponse(HttpResponse response) {
        try {
            TunnelStatusCheckRestResponse restResponse = (TunnelStatusCheckRestResponse)RestUtil.OBJECT_MAPPER.readValue(response.getEntity().getContent(), TunnelStatusCheckRestResponse.class);
            if (restResponse.getCheckIntervalSeconds() != null && restResponse.getCheckIntervalSeconds() > 0L) {
                return Duration.ofSeconds(restResponse.getCheckIntervalSeconds());
            }
        }
        catch (IOException e) {
            log.debug("Failed to parse rest response", (Throwable)e);
        }
        return DEFAULT_INTERVAL;
    }

    private void logResponse(HttpResponse response) {
        if (log.isDebugEnabled()) {
            try {
                log.debug("Response from tunnel status endpoint: {}", (Object)StringUtils.defaultString((String)EntityUtils.toString((HttpEntity)response.getEntity())));
            }
            catch (Exception e) {
                log.debug("Failed to log response", (Throwable)e);
            }
        }
    }

    @JsonAutoDetect
    static class TunnelStatusCheckRestResponse {
        private Long checkIntervalSeconds;

        @Generated
        public Long getCheckIntervalSeconds() {
            return this.checkIntervalSeconds;
        }

        @Generated
        public void setCheckIntervalSeconds(Long checkIntervalSeconds) {
            this.checkIntervalSeconds = checkIntervalSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TunnelStatusCheckRestResponse)) {
                return false;
            }
            TunnelStatusCheckRestResponse other = (TunnelStatusCheckRestResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$checkIntervalSeconds = this.getCheckIntervalSeconds();
            Long other$checkIntervalSeconds = other.getCheckIntervalSeconds();
            return !(this$checkIntervalSeconds == null ? other$checkIntervalSeconds != null : !((Object)this$checkIntervalSeconds).equals(other$checkIntervalSeconds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TunnelStatusCheckRestResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $checkIntervalSeconds = this.getCheckIntervalSeconds();
            result = result * 59 + ($checkIntervalSeconds == null ? 43 : ((Object)$checkIntervalSeconds).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TunnelStatusCheckService.TunnelStatusCheckRestResponse(checkIntervalSeconds=" + this.getCheckIntervalSeconds() + ")";
        }

        @Generated
        public TunnelStatusCheckRestResponse() {
        }

        @Generated
        public TunnelStatusCheckRestResponse(Long checkIntervalSeconds) {
            this.checkIntervalSeconds = checkIntervalSeconds;
        }
    }
}

