/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.dao;

import com.atlassian.db.config.password.ciphers.algorithm.AlgorithmCipher;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.DecryptionParameters;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.EncryptionParameters;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;

public class TunnelCipher
extends AlgorithmCipher {
    private final Gson gson = new Gson();
    private final Supplier<Path> outputFilesBasePathSupplier;

    public TunnelCipher(Supplier<Path> outputFilesBasePathSupplier) {
        this.outputFilesBasePathSupplier = outputFilesBasePathSupplier;
    }

    @Override
    public String encrypt(String password) {
        Path outputFileBasePath = this.outputFilesBasePathSupplier.get();
        EncryptionParameters encryptionParameters = new EncryptionParameters.Builder().setAlgorithm("AES/CBC/PKCS5Padding").setAlgorithmKey("AES").setOutputFilesBasePath(outputFileBasePath + File.separator).setSaveAlgorithmParametersToSeparateFile(false).setSaveSealedObjectToSeparateFile(false).setPlainTextPassword(password).build();
        String encryptedData = super.encrypt(this.gson.toJson((Object)encryptionParameters));
        DecryptionParameters withAbsolutePath = (DecryptionParameters)this.gson.fromJson(encryptedData, DecryptionParameters.class);
        DecryptionParameters withRelativePath = this.relativize(outputFileBasePath, withAbsolutePath);
        return this.gson.toJson((Object)withRelativePath);
    }

    @Override
    public String decrypt(String encryptedData) {
        DecryptionParameters withAbsolutePath = this.toDecryptionParametersWithAbsolutePath(encryptedData);
        return super.decrypt(this.gson.toJson((Object)withAbsolutePath));
    }

    public void deleteKey(String encryptedData) throws IOException {
        DecryptionParameters withAbsolutePath = this.toDecryptionParametersWithAbsolutePath(encryptedData);
        Files.delete(Paths.get(withAbsolutePath.getKeyFilePath(), new String[0]));
    }

    private DecryptionParameters toDecryptionParametersWithAbsolutePath(String encryptedData) {
        DecryptionParameters withRelativePath = (DecryptionParameters)this.gson.fromJson(encryptedData, DecryptionParameters.class);
        return this.absolutize(this.outputFilesBasePathSupplier.get(), withRelativePath);
    }

    private String relativize(Path base, String path) {
        return base.toUri().relativize(new File(path).toURI()).getPath();
    }

    private DecryptionParameters relativize(Path base, DecryptionParameters withAbsolutePath) {
        return new DecryptionParameters(withAbsolutePath.getSealedObjectFilePath(), this.relativize(base, withAbsolutePath.getKeyFilePath()), withAbsolutePath.getSerializedSealedObject());
    }

    private String absolutize(Path base, String path) {
        return base.resolve(path).toString();
    }

    private DecryptionParameters absolutize(Path base, DecryptionParameters withRelativePath) {
        return new DecryptionParameters(withRelativePath.getSealedObjectFilePath(), this.absolutize(base, withRelativePath.getKeyFilePath()), withRelativePath.getSerializedSealedObject());
    }
}

