/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.TunnelAuditService;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class DefaultTunnelAuditService
implements TunnelAuditService {
    protected static final String TUNNEL_AUDIT_EVENT_CATEGORY = "tunnel.client.audit.logging.general.configuration";
    protected static final String TUNNEL_AUDIT_EVENT_TUNNEL_NAME = "tunnel.client.audit.tunnel.name";
    private final AuditService auditService;
    private final I18nResolver i18n;

    @Override
    public void audit(String eventSummaryKey, String tunnelName) {
        String categoryKey = TUNNEL_AUDIT_EVENT_CATEGORY;
        AuditAttribute tunnelNameAttribute = AuditAttribute.fromI18nKeys((String)TUNNEL_AUDIT_EVENT_TUNNEL_NAME, (String)tunnelName).build();
        this.auditService.audit(this.getBaseAuditEventBuilder(TUNNEL_AUDIT_EVENT_CATEGORY, this.i18n.getText(eventSummaryKey), Arrays.asList(tunnelNameAttribute)).build());
    }

    private AuditEvent.Builder getBaseAuditEventBuilder(String categoryKey, String summary, List<AuditAttribute> extraAttributes) {
        return AuditEvent.fromI18nKeys((String)categoryKey, (String)summary, (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION).extraAttributes(extraAttributes);
    }

    @Generated
    public DefaultTunnelAuditService(AuditService auditService, I18nResolver i18n) {
        this.auditService = auditService;
        this.i18n = i18n;
    }
}

