/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.monitoring.scheduled;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.scheduled.TunnelScheduledJob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelConnectionClusterSyncJob
implements TunnelScheduledJob {
    private static final Logger log = LoggerFactory.getLogger(TunnelConnectionClusterSyncJob.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)TunnelConnectionClusterSyncJob.class.getName());
    private static final JobId JOB_ID = JobId.of((String)TunnelConnectionClusterSyncJob.class.getSimpleName());
    private final TunnelConnectionService tunnelConnectionService;
    private final SchedulerService schedulerService;
    private final TunnelProperties tunnelProperties;

    @Override
    public void schedule() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new TunnelConnectionClusterSyncJobRunner());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(this.createSchedule());
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Could not schedule job {}", (Object)TunnelConnectionClusterSyncJob.class.getName());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unschedule() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private Schedule createSchedule() {
        return Schedule.forInterval((long)this.tunnelProperties.getClusterSyncInterval(), null);
    }

    @Generated
    public TunnelConnectionClusterSyncJob(TunnelConnectionService tunnelConnectionService, SchedulerService schedulerService, TunnelProperties tunnelProperties) {
        this.tunnelConnectionService = tunnelConnectionService;
        this.schedulerService = schedulerService;
        this.tunnelProperties = tunnelProperties;
    }

    public class TunnelConnectionClusterSyncJobRunner
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            TunnelConnectionClusterSyncJob.this.tunnelConnectionService.syncTunnelConnectionsToClusterState();
            return JobRunnerResponse.success();
        }
    }
}

