/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.file.TunnelWorkingDirectoryProvider;
import com.atlassian.tunnel.process.exception.InletsTokenFileCreationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;

public class InletsTokenFileManager {
    static final String TOKEN_FILE_NAME = "token";
    private final TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider;
    private final NodeIdProvider nodeIdProvider;

    public String writeTokenToFile(String token) throws IOException {
        this.deleteTokenFile();
        File tokenFile = new File(this.getFilePath().toString());
        tokenFile.createNewFile();
        if (!tokenFile.setReadable(true)) {
            throw new InletsTokenFileCreationException("Not enough permissions to set READ permission");
        }
        if (!tokenFile.setWritable(true)) {
            throw new InletsTokenFileCreationException("Not enough permissions to set WRITE permission");
        }
        tokenFile.setExecutable(false, false);
        Files.write(tokenFile.toPath(), Collections.singletonList(token), new OpenOption[0]);
        return tokenFile.getAbsolutePath();
    }

    public void deleteTokenFile() throws IOException {
        Path path = this.getFilePath();
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
    }

    private Path getFilePath() throws IOException {
        return Paths.get(this.tunnelWorkingDirectoryProvider.getPath().toString(), this.getTokenFileName());
    }

    private String getTokenFileName() {
        return this.nodeIdProvider.getLocalNodeId().map(it -> it + "_token").orElse(TOKEN_FILE_NAME);
    }

    public InletsTokenFileManager(TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider, NodeIdProvider nodeIdProvider) {
        this.tunnelWorkingDirectoryProvider = tunnelWorkingDirectoryProvider;
        this.nodeIdProvider = nodeIdProvider;
    }
}

