/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.dev;

import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.dev.EventCapturingLogger;
import com.atlassian.tunnel.dev.LogCapturingDataObfuscator;
import com.atlassian.tunnel.dev.LoggingEventData;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import com.atlassian.tunnel.security.DefaultConfidentialDataObfuscator;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;

public class DevConfidentialDataObfuscator
implements ConfidentialDataObfuscator,
LogCapturingDataObfuscator {
    private final DefaultConfidentialDataObfuscator defaultConfidentialDataObfuscator;
    final Queue<LoggingEventData> eventQueue = new LinkedBlockingQueue<LoggingEventData>();

    public DevConfidentialDataObfuscator(TunnelService tunnelService, TunnelProperties tunnelProperties) {
        this.defaultConfidentialDataObfuscator = new DefaultConfidentialDataObfuscator(tunnelService, tunnelProperties);
    }

    @Override
    public void logError(Logger logger, String format, Object ... args) {
        logger.error(format, args);
        EventCapturingLogger devLogger = new EventCapturingLogger(logger, this.eventQueue);
        this.defaultConfidentialDataObfuscator.logError((Logger)devLogger, format, args);
    }

    @Override
    public void logError(Logger logger, String message, Throwable exception) {
        logger.error(message, exception);
        EventCapturingLogger devLogger = new EventCapturingLogger(logger, this.eventQueue);
        this.defaultConfidentialDataObfuscator.logError((Logger)devLogger, message, exception);
    }

    @Override
    public void logDebug(Logger logger, String format, Object ... args) {
        logger.debug(format, args);
        EventCapturingLogger devLogger = new EventCapturingLogger(logger, this.eventQueue);
        this.defaultConfidentialDataObfuscator.logDebug(devLogger, format, args);
    }

    @Override
    public void logInfo(Logger logger, String format, Object ... args) {
        logger.info(format, args);
        EventCapturingLogger devLogger = new EventCapturingLogger(logger, this.eventQueue);
        this.defaultConfidentialDataObfuscator.logInfo(devLogger, format, args);
    }

    @Override
    public void logWarn(Logger logger, String format, Object ... args) {
        EventCapturingLogger devLogger = new EventCapturingLogger(logger, this.eventQueue);
        this.defaultConfidentialDataObfuscator.logWarn(devLogger, format, args);
    }

    @Override
    public List<LoggingEventData> getLoggingEvents() {
        return new ArrayList<LoggingEventData>(this.eventQueue);
    }

    @Override
    public void clearLoggingEvents() {
        this.eventQueue.clear();
    }
}

