/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.rest.external;

import com.atlassian.tunnel.configuration.rest.external.TunnelStatusCheckService;
import java.time.Duration;
import java.util.Objects;
import lombok.NonNull;

public class TunnelStatusCheckResponse {
    @NonNull
    private final Duration checkInterval;
    @NonNull
    private final Status status;

    private TunnelStatusCheckResponse(Duration checkInterval, Status status) {
        this.checkInterval = Objects.requireNonNull(checkInterval, "checkInterval");
        this.status = Objects.requireNonNull(status, "status");
    }

    public static TunnelStatusCheckResponse available(Duration nextInterval) {
        return new TunnelStatusCheckResponse(nextInterval, Status.AVAILABLE);
    }

    public static TunnelStatusCheckResponse unavailable() {
        return new TunnelStatusCheckResponse(TunnelStatusCheckService.DEFAULT_INTERVAL, Status.UNAVAILABLE);
    }

    public static TunnelStatusCheckResponse unknown() {
        return new TunnelStatusCheckResponse(TunnelStatusCheckService.DEFAULT_INTERVAL, Status.UNKNOWN);
    }

    @NonNull
    public Duration getCheckInterval() {
        return this.checkInterval;
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TunnelStatusCheckResponse)) {
            return false;
        }
        TunnelStatusCheckResponse other = (TunnelStatusCheckResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Duration this$checkInterval = this.getCheckInterval();
        Duration other$checkInterval = other.getCheckInterval();
        if (this$checkInterval == null ? other$checkInterval != null : !((Object)this$checkInterval).equals(other$checkInterval)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TunnelStatusCheckResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Duration $checkInterval = this.getCheckInterval();
        result = result * 59 + ($checkInterval == null ? 43 : ((Object)$checkInterval).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "TunnelStatusCheckResponse(checkInterval=" + this.getCheckInterval() + ", status=" + this.getStatus() + ")";
    }

    public static enum Status {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }
}

