/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.upgrade;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.tunnel.file.HomeDirectoryHelper;
import com.atlassian.tunnel.upgrade.FileSystemUtilsWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask002
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask002.class);
    private final ApplicationProperties applicationProperties;
    private final FileSystemUtilsWrapper fileSystemUtilsWrapper;

    public UpgradeTask002(ApplicationProperties applicationProperties, FileSystemUtilsWrapper fileSystemUtilsWrapper) {
        this.applicationProperties = applicationProperties;
        this.fileSystemUtilsWrapper = fileSystemUtilsWrapper;
    }

    public int getBuildNumber() {
        return 2;
    }

    @Nonnull
    public String getShortDescription() {
        return "Delete secure-tunnel folder from shared folder";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws IOException {
        Path sharedHomeDirectory = new HomeDirectoryHelper(this.applicationProperties).getSharedHomeDirectory();
        if (Objects.isNull(sharedHomeDirectory) || sharedHomeDirectory.toString().isEmpty()) {
            log.info("No shared home directory detected - skipping");
        } else {
            try {
                if (!this.fileSystemUtilsWrapper.deleteRecursively(sharedHomeDirectory)) {
                    log.info("secure-tunnel folder not found in shared home directory");
                }
            }
            catch (IOException exception) {
                log.warn("Could not delete secure-tunnel folder from: {}", (Object)sharedHomeDirectory, (Object)exception);
            }
        }
        return Collections.emptySet();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.securetunnel.client.tunnel-client-plugin";
    }
}

