/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.file;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class HomeDirectoryHelper {
    public static final String HOME_DIR_ERROR_MSG = "Could not create working directory, home directory is not defined.";
    public final ApplicationProperties applicationProperties;

    public HomeDirectoryHelper(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Path getLocalHomeDirectory() throws IOException {
        return this.getHomeDirectory("getLocalHomeDirectory");
    }

    public Path getSharedHomeDirectory() throws IOException {
        return this.getHomeDirectory("getSharedHomeDirectory");
    }

    Path getHomeDirectory(String methodName) throws IOException {
        try {
            Method method = this.applicationProperties.getClass().getMethod(methodName, new Class[0]);
            Object result = method.invoke((Object)this.applicationProperties, new Object[0]);
            if (!(result instanceof Optional)) {
                throw new IOException(HOME_DIR_ERROR_MSG);
            }
            Optional optionalResult = (Optional)result;
            if (!optionalResult.isPresent()) {
                return null;
            }
            Object pathResult = optionalResult.get();
            if (!(pathResult instanceof Path)) {
                throw new IOException(HOME_DIR_ERROR_MSG);
            }
            return ((Path)pathResult).resolve("secure-tunnel");
        }
        catch (NoSuchMethodException e) {
            File homeDirectory = this.applicationProperties.getHomeDirectory();
            if (homeDirectory == null) {
                throw new IOException(HOME_DIR_ERROR_MSG);
            }
            return Paths.get(homeDirectory.getPath(), "secure-tunnel");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get home directory", e);
        }
    }
}

