/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.rest;

import com.atlassian.tunnel.configuration.exception.InvalidTunnelConfigurationException;
import com.atlassian.tunnel.rest.RestError;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InvalidTunnelConfigurationExceptionMapper
implements ExceptionMapper<InvalidTunnelConfigurationException> {
    private static final Logger log = LoggerFactory.getLogger(InvalidTunnelConfigurationExceptionMapper.class);

    public Response toResponse(InvalidTunnelConfigurationException exception) {
        log.trace("{} has been caught, mapping to REST response", (Object)InvalidTunnelConfigurationException.class.getName());
        String errorMessage = this.determineErrorMessage(exception.getReason());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new RestError(errorMessage)).build();
    }

    private String determineErrorMessage(InvalidTunnelConfigurationException.Reason reason) {
        if (reason == InvalidTunnelConfigurationException.Reason.EMPTY) {
            return "You need to provide the security key.";
        }
        if (reason == InvalidTunnelConfigurationException.Reason.INVALID) {
            return "You need to provide a valid key.";
        }
        return "There was a problem";
    }
}

