/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.dao;

import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSubdirectorySupplier
implements Supplier<Path> {
    private static final Logger log = LoggerFactory.getLogger(SharedSubdirectorySupplier.class);
    private final ApplicationProperties applicationProperties;
    private final String sharedSubdirectory;
    public static final String GET_SHARED_DIRECTORY = "getSharedHomeDirectory";

    public SharedSubdirectorySupplier(ApplicationProperties applicationProperties, String sharedSubdirectory) {
        this.applicationProperties = applicationProperties;
        this.sharedSubdirectory = sharedSubdirectory;
    }

    @Override
    public Path get() {
        Path path;
        try {
            path = Paths.get(this.getSharedHome(), this.sharedSubdirectory);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.createIfNotExists(path);
        return path;
    }

    private String getSharedHome() throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        switch (this.applicationProperties.getPlatformId()) {
            case "jira": 
            case "conf": 
            case "fisheye": {
                return Objects.requireNonNull(this.applicationProperties.getHomeDirectory()).getPath();
            }
            case "bamboo": {
                try {
                    return this.applicationProperties.getClass().getMethod(GET_SHARED_DIRECTORY, new Class[0]).invoke((Object)this.applicationProperties, new Object[0]).toString();
                }
                catch (NoSuchMethodException e) {
                    return Objects.requireNonNull(this.applicationProperties.getHomeDirectory()).getPath();
                }
            }
            case "bitbucket": {
                return OsgiServices.importOsgiService(StorageService.class).getSharedHomeDir().toString();
            }
        }
        throw new IllegalStateException("Platform not supported");
    }

    private void createIfNotExists(Path sharedHomeSubdirectoryPath) {
        if (!Files.exists(sharedHomeSubdirectoryPath, new LinkOption[0])) {
            log.info("Shared home subdirectory doesn't exist, trying to create an empty one in {}", (Object)sharedHomeSubdirectoryPath);
            try {
                Files.createDirectories(sharedHomeSubdirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create shared home subdirectory at " + sharedHomeSubdirectoryPath);
            }
        }
    }
}

