/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.audit.event.TunnelCreatedEvent;
import com.atlassian.tunnel.audit.event.TunnelDeletedEvent;
import com.atlassian.tunnel.audit.event.TunnelUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TunnelAuditEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TunnelAuditEventListener.class);
    private final TunnelAuditService tunnelAuditService;
    private final EventPublisher eventPublisher;
    protected static final String TUNNEL_CREATED_AUDIT_EVENT_SUMMARY = "Tunnel created";
    protected static final String TUNNEL_DELETED_AUDIT_EVENT_SUMMARY = "Tunnel deleted";
    protected static final String TUNNEL_UPDATED_AUDIT_EVENT_SUMMARY = "Tunnel updated";

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onTunnelCreated(TunnelCreatedEvent event) {
        log.debug("Received TunnelCreatedEvent: {}", (Object)event);
        this.tunnelAuditService.audit(TUNNEL_CREATED_AUDIT_EVENT_SUMMARY, event.getTunnelName());
    }

    @EventListener
    public void onTunnelDeleted(TunnelDeletedEvent event) {
        log.debug("Received TunnelDeletedEvent: {}", (Object)event);
        this.tunnelAuditService.audit(TUNNEL_DELETED_AUDIT_EVENT_SUMMARY, event.getTunnelName());
    }

    @EventListener
    public void onTunnelUpdated(TunnelUpdatedEvent event) {
        log.debug("Received TunnelUpdatedEvent: {}", (Object)event);
        this.tunnelAuditService.audit(TUNNEL_UPDATED_AUDIT_EVENT_SUMMARY, event.getTunnelName());
    }

    public TunnelAuditEventListener(TunnelAuditService tunnelAuditService, EventPublisher eventPublisher) {
        this.tunnelAuditService = tunnelAuditService;
        this.eventPublisher = eventPublisher;
    }
}

