/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.analytics;

import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.tunnel.analytics.TunnelAnalyticsEvent;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;

public class TunnelClientAnalyticsEventPublisher
implements EventListenerRegistrar {
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private String version;

    public TunnelClientAnalyticsEventPublisher(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public void publish(TunnelAnalyticsEvent tunnelAnalyticsEvent) {
        tunnelAnalyticsEvent.setPluginVersion(this.version);
        this.eventPublisher.publish((Object)tunnelAnalyticsEvent);
    }

    @PostConstruct
    private void getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin("com.atlassian.securetunnel.client.tunnel-client-plugin");
        if (plugin != null) {
            Optional<String> pluginVersion = Optional.of(plugin.getPluginInformation().getVersion());
            this.version = pluginVersion.orElse("0.0");
            return;
        }
        this.version = "0.0";
    }

    public void register(@Nonnull Object listener) {
        this.eventPublisher.register(listener);
    }

    public void unregister(@Nonnull Object listener) {
        this.eventPublisher.unregister(listener);
    }

    public void unregisterAll() {
        this.eventPublisher.unregisterAll();
    }
}

