/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.TransactionalAnnotationProcessor;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.tunnel.PluginLifecycleListener;
import com.atlassian.tunnel.analytics.TunnelClientAnalyticsEventPublisher;
import com.atlassian.tunnel.audit.TunnelAuditEventListener;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.configuration.TunnelConfigurationKeyDecoder;
import com.atlassian.tunnel.configuration.TunnelEventListener;
import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.configuration.dao.ActiveObjectsTunnelDao;
import com.atlassian.tunnel.configuration.dao.CachedTunnelDao;
import com.atlassian.tunnel.configuration.dao.EncryptingTunnelDao;
import com.atlassian.tunnel.configuration.dao.SharedSubdirectorySupplier;
import com.atlassian.tunnel.configuration.dao.TunnelCipher;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import com.atlassian.tunnel.configuration.rest.external.TunnelStatusCheckService;
import com.atlassian.tunnel.configuration.scheduled.TunnelRefreshJob;
import com.atlassian.tunnel.configuration.scheduled.TunnelStatusCheckJob;
import com.atlassian.tunnel.file.InletsExecutableFactory;
import com.atlassian.tunnel.file.TunnelWorkingDirectoryProvider;
import com.atlassian.tunnel.monitoring.TunnelConnectionEventListener;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.monitoring.dao.ActiveObjectsTunnelConnectionDao;
import com.atlassian.tunnel.monitoring.dao.TunnelConnectionDao;
import com.atlassian.tunnel.monitoring.scheduled.TunnelConnectionClusterSyncJob;
import com.atlassian.tunnel.process.InletsClientManager;
import com.atlassian.tunnel.process.InletsClientProcessFactory;
import com.atlassian.tunnel.process.InletsTokenFileManager;
import com.atlassian.tunnel.process.TunnelClientProcessStateManager;
import com.atlassian.tunnel.process.TunnelExecutorServiceProvider;
import com.atlassian.tunnel.properties.OperatingSystemProvider;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.scheduled.TunnelScheduledJob;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import com.atlassian.tunnel.security.DefaultConfidentialDataObfuscator;
import com.atlassian.tunnel.security.PermissionEnforcer;
import com.atlassian.tunnel.upgrade.FileSystemUtilsWrapper;
import com.atlassian.tunnel.upgrade.UpgradeTask001;
import com.atlassian.tunnel.upgrade.UpgradeTask002;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TunnelClientConfiguration {
    @Bean
    public PluginLifecycleListener pluginLifecycleListener(InletsClientManager inletsClientManager, EventPublisher eventPublisher, List<TunnelScheduledJob> tunnelScheduledJobs) {
        return new PluginLifecycleListener(inletsClientManager, eventPublisher, tunnelScheduledJobs);
    }

    @Bean
    public InletsClientManager inletsClientManager(InletsExecutableFactory inletsExecutableFactory, InletsClientProcessFactory inletsClientProcessFactory, TunnelClientProcessStateManager tunnelClientProcessStateManager, TunnelProperties tunnelProperties, ConfidentialDataObfuscator confidentialDataObfuscator, InletsTokenFileManager inletsTokenFileManager, TunnelExecutorServiceProvider tunnelExecutorServiceProvider, TunnelClientAnalyticsEventPublisher tunnelClientAnalyticsEventPublisher) {
        return new InletsClientManager(inletsExecutableFactory, inletsClientProcessFactory, tunnelClientProcessStateManager, tunnelProperties, confidentialDataObfuscator, inletsTokenFileManager, tunnelExecutorServiceProvider, tunnelClientAnalyticsEventPublisher);
    }

    @Bean
    public InletsClientProcessFactory inletsClientProcessFactory(TunnelExecutorServiceProvider tunnelExecutorServiceProvider, TunnelService tunnelService, TunnelProperties tunnelProperties, ConfidentialDataObfuscator confidentialDataObfuscator, InletsTokenFileManager inletsTokenFileManager) {
        return new InletsClientProcessFactory(tunnelExecutorServiceProvider, tunnelService, tunnelProperties, confidentialDataObfuscator, inletsTokenFileManager);
    }

    @Bean
    public TunnelClientProcessStateManager tunnelClientProcessStateManager(EventPublisher eventPublisher) {
        return new TunnelClientProcessStateManager(eventPublisher);
    }

    @Bean
    public InletsExecutableFactory inletsExecutableFactory(TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider, OperatingSystemProvider operatingSystemProvider) {
        return new InletsExecutableFactory(tunnelWorkingDirectoryProvider, operatingSystemProvider);
    }

    @Bean
    public InletsTokenFileManager inletsTokenFileManager(TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider, NodeIdProvider nodeIdProvider) {
        return new InletsTokenFileManager(tunnelWorkingDirectoryProvider, nodeIdProvider);
    }

    @Bean
    public TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider(ApplicationProperties applicationProperties) {
        return new TunnelWorkingDirectoryProvider(applicationProperties);
    }

    @Bean
    public TunnelService tunnelService(@Qualifier(value="cachedTunnelDao") TunnelDao cachedTunnelDao, TunnelConnectionService tunnelConnectionService, EventPublisher eventPublisher) {
        return new TunnelService(cachedTunnelDao, tunnelConnectionService, eventPublisher);
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newWorkStealingPool();
    }

    @Bean
    public TunnelConfigurationKeyDecoder tunnelConfigurationKeyDecoder(ConfidentialDataObfuscator confidentialDataObfuscator) {
        return new TunnelConfigurationKeyDecoder(confidentialDataObfuscator);
    }

    @Bean
    public TunnelEventListener tunnelConfigurationEventListener(InletsClientManager inletsClientManager, @Qualifier(value="cachedTunnelDao") TunnelDao tunnelDao, EventPublisher eventPublisher) {
        return new TunnelEventListener(inletsClientManager, tunnelDao, eventPublisher);
    }

    @Bean
    public TunnelScheduledJob tunnelRefreshJob(TunnelService tunnelService, TunnelProperties tunnelProperties, SchedulerService schedulerService) {
        return new TunnelRefreshJob(tunnelService, tunnelProperties, schedulerService);
    }

    @Bean
    public TunnelStatusCheckService tunnelStatusCheckService(TunnelProperties tunnelProperties) {
        return new TunnelStatusCheckService(tunnelProperties);
    }

    @Bean
    public TunnelStatusCheckJob tunnelStatusCheckJob(TunnelStatusCheckService tunnelStatusCheckService, TunnelService tunnelService, TunnelConnectionService tunnelConnectionService, EventPublisher eventPublisher, SchedulerService schedulerService) {
        return new TunnelStatusCheckJob(Clock.systemDefaultZone(), tunnelStatusCheckService, tunnelService, tunnelConnectionService, eventPublisher, schedulerService);
    }

    @Bean(name={"cachedTunnelDao"})
    public TunnelDao cachedTunnelDao(@Qualifier(value="tunnelDao") TunnelDao tunnelDao, CacheManager cacheManager, EventPublisher eventPublisher, ExecutorService executorService) {
        return new CachedTunnelDao(tunnelDao, cacheManager, eventPublisher, executorService);
    }

    @Bean(name={"tunnelDao"})
    public TunnelDao encryptingTunnelDao(ActiveObjects activeObjects, ApplicationProperties applicationProperties) {
        SharedSubdirectorySupplier sharedSubdirectorySupplier = new SharedSubdirectorySupplier(applicationProperties, "secure-tunnel-key");
        return new EncryptingTunnelDao(new ActiveObjectsTunnelDao(activeObjects), new TunnelCipher(sharedSubdirectorySupplier));
    }

    @Bean
    public TunnelConnectionService tunnelConnectionService(TunnelConnectionDao tunnelConnectionDao, NodeIdProvider nodeIdProvider) {
        return new TunnelConnectionService(tunnelConnectionDao, nodeIdProvider);
    }

    @Bean
    public TunnelClientAnalyticsEventPublisher tunnelClientAnalyticsEventPublisher(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        return new TunnelClientAnalyticsEventPublisher(eventPublisher, pluginAccessor);
    }

    @Bean
    public TunnelConnectionEventListener tunnelConnectionEventListener(TunnelConnectionService tunnelConnectionService, TunnelClientAnalyticsEventPublisher tunnelClientAnalyticsEventPublisher) {
        return new TunnelConnectionEventListener(tunnelConnectionService, tunnelClientAnalyticsEventPublisher);
    }

    @Bean
    public TunnelAuditEventListener tunnelAuditListener(TunnelAuditService tunnelAuditService, EventPublisher eventPublisher) {
        return new TunnelAuditEventListener(tunnelAuditService, eventPublisher);
    }

    @Bean
    public TunnelScheduledJob tunnelConnectionClusterSyncJob(TunnelConnectionService tunnelConnectionService, SchedulerService schedulerService, TunnelProperties tunnelProperties) {
        return new TunnelConnectionClusterSyncJob(tunnelConnectionService, schedulerService, tunnelProperties);
    }

    @Bean
    public TunnelConnectionDao tunnelConnectionDao(ActiveObjects activeObjects) {
        return new ActiveObjectsTunnelConnectionDao(activeObjects);
    }

    @Bean
    public TransactionalAnnotationProcessor transactionalAnnotationProcessor(ActiveObjects activeObjects) {
        return new TransactionalAnnotationProcessor(activeObjects);
    }

    @Bean
    public ConfidentialDataObfuscator confidentialDataObfuscator(TunnelService tunnelService, TunnelProperties tunnelProperties) {
        return new DefaultConfidentialDataObfuscator(tunnelService, tunnelProperties);
    }

    @Bean
    public OperatingSystemProvider operatingSystemProvider() {
        return new OperatingSystemProvider();
    }

    @Bean
    public TunnelExecutorServiceProvider tunnelExecutorServiceProvider() {
        return new TunnelExecutorServiceProvider();
    }

    @Bean
    public PermissionEnforcer permissionEnforcer(UserManager salUserManager) {
        return new PermissionEnforcer(salUserManager);
    }

    @Bean
    public FactoryBean<ServiceRegistration> tunnelClientUpgradeTask001(ActiveObjects activeObjects, @Qualifier(value="cachedTunnelDao") TunnelDao encryptingTunnelDao) {
        return OsgiServices.exportOsgiService(new UpgradeTask001(new ActiveObjectsTunnelDao(activeObjects), encryptingTunnelDao), ExportOptions.as(PluginUpgradeTask.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> tunnelClientUpgradeTask002(ApplicationProperties applicationProperties) {
        return OsgiServices.exportOsgiService(new UpgradeTask002(applicationProperties, new FileSystemUtilsWrapper()), ExportOptions.as(PluginUpgradeTask.class, new Class[0]));
    }
}

