/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration;

import com.atlassian.tunnel.configuration.TunnelConfigurationKeyDecoder;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tunnel {
    private static final Logger log = LoggerFactory.getLogger(Tunnel.class);
    private final String name;
    private final String cloudOrgName;
    private final String cloudPageUrl;
    private final String upstreamDnsUrl;
    private final String token;

    public static Tunnel fromKey(TunnelConfigurationKeyDecoder.TunnelConfigurationKey key) {
        return Tunnel.builder().name(key.getName()).cloudOrgName(key.getCloudOrgName()).cloudPageUrl(key.getCloudPageUrl()).upstreamDnsUrl(key.getUpstreamDnsUrl()).token(key.getToken()).build();
    }

    public String getUpstreamDnsUrlAuthority() {
        try {
            URL url = new URL(this.upstreamDnsUrl);
            return url.getAuthority();
        }
        catch (MalformedURLException e) {
            log.error("Unable to parse upstreamDnsUrl to obtain authority part of URL, returning original");
            return this.upstreamDnsUrl;
        }
    }

    Tunnel(String name, String cloudOrgName, String cloudPageUrl, String upstreamDnsUrl, String token) {
        this.name = name;
        this.cloudOrgName = cloudOrgName;
        this.cloudPageUrl = cloudPageUrl;
        this.upstreamDnsUrl = upstreamDnsUrl;
        this.token = token;
    }

    public static TunnelBuilder builder() {
        return new TunnelBuilder();
    }

    public TunnelBuilder toBuilder() {
        return new TunnelBuilder().name(this.name).cloudOrgName(this.cloudOrgName).cloudPageUrl(this.cloudPageUrl).upstreamDnsUrl(this.upstreamDnsUrl).token(this.token);
    }

    public String getName() {
        return this.name;
    }

    public String getCloudOrgName() {
        return this.cloudOrgName;
    }

    public String getCloudPageUrl() {
        return this.cloudPageUrl;
    }

    public String getUpstreamDnsUrl() {
        return this.upstreamDnsUrl;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tunnel)) {
            return false;
        }
        Tunnel other = (Tunnel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cloudOrgName = this.getCloudOrgName();
        String other$cloudOrgName = other.getCloudOrgName();
        if (this$cloudOrgName == null ? other$cloudOrgName != null : !this$cloudOrgName.equals(other$cloudOrgName)) {
            return false;
        }
        String this$cloudPageUrl = this.getCloudPageUrl();
        String other$cloudPageUrl = other.getCloudPageUrl();
        if (this$cloudPageUrl == null ? other$cloudPageUrl != null : !this$cloudPageUrl.equals(other$cloudPageUrl)) {
            return false;
        }
        String this$upstreamDnsUrl = this.getUpstreamDnsUrl();
        String other$upstreamDnsUrl = other.getUpstreamDnsUrl();
        if (this$upstreamDnsUrl == null ? other$upstreamDnsUrl != null : !this$upstreamDnsUrl.equals(other$upstreamDnsUrl)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tunnel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cloudOrgName = this.getCloudOrgName();
        result = result * 59 + ($cloudOrgName == null ? 43 : $cloudOrgName.hashCode());
        String $cloudPageUrl = this.getCloudPageUrl();
        result = result * 59 + ($cloudPageUrl == null ? 43 : $cloudPageUrl.hashCode());
        String $upstreamDnsUrl = this.getUpstreamDnsUrl();
        result = result * 59 + ($upstreamDnsUrl == null ? 43 : $upstreamDnsUrl.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "Tunnel(name=" + this.getName() + ", cloudOrgName=" + this.getCloudOrgName() + ", cloudPageUrl=" + this.getCloudPageUrl() + ", upstreamDnsUrl=" + this.getUpstreamDnsUrl() + ", token=" + this.getToken() + ")";
    }

    public static class TunnelBuilder {
        private String name;
        private String cloudOrgName;
        private String cloudPageUrl;
        private String upstreamDnsUrl;
        private String token;

        TunnelBuilder() {
        }

        public TunnelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TunnelBuilder cloudOrgName(String cloudOrgName) {
            this.cloudOrgName = cloudOrgName;
            return this;
        }

        public TunnelBuilder cloudPageUrl(String cloudPageUrl) {
            this.cloudPageUrl = cloudPageUrl;
            return this;
        }

        public TunnelBuilder upstreamDnsUrl(String upstreamDnsUrl) {
            this.upstreamDnsUrl = upstreamDnsUrl;
            return this;
        }

        public TunnelBuilder token(String token) {
            this.token = token;
            return this;
        }

        public Tunnel build() {
            return new Tunnel(this.name, this.cloudOrgName, this.cloudPageUrl, this.upstreamDnsUrl, this.token);
        }

        public String toString() {
            return "Tunnel.TunnelBuilder(name=" + this.name + ", cloudOrgName=" + this.cloudOrgName + ", cloudPageUrl=" + this.cloudPageUrl + ", upstreamDnsUrl=" + this.upstreamDnsUrl + ", token=" + this.token + ")";
        }
    }
}

