/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.monitoring;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.tunnel.analytics.TunnelConnectedAnalyticsEvent;
import com.atlassian.tunnel.analytics.TunnelErrorAnalyticsEvent;
import com.atlassian.tunnel.analytics.TunnelReconnectedAnalyticsEvent;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.process.TunnelProcessState;
import com.atlassian.tunnel.process.event.TunnelProcessStateUpdatedEvent;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TunnelConnectionEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TunnelConnectionEventListener.class);
    private final TunnelConnectionService tunnelConnectionService;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void updateTunnelConnection(TunnelProcessStateUpdatedEvent event) {
        log.trace("Received {}: {}", (Object)TunnelProcessStateUpdatedEvent.class.getSimpleName(), (Object)event);
        this.tunnelConnectionService.updateLocalTunnelConnection(event.getNewState());
        this.publishAnalytics(event);
    }

    private void publishAnalytics(TunnelProcessStateUpdatedEvent event) {
        TunnelProcessState.Status newStatus = event.getNewState().getStatus();
        TunnelProcessState.Status previousStatus = event.getPreviousState().getStatus();
        int retryCount = event.getNewState().getRetryCount();
        String version = this.getPluginVersion().orElse("0.0");
        if (TunnelProcessState.Status.AUTHENTICATION_FAILED == newStatus) {
            this.eventPublisher.publish((Object)new TunnelErrorAnalyticsEvent(version, Response.Status.UNAUTHORIZED.getStatusCode()));
        }
        if (TunnelProcessState.Status.RESTARTING == newStatus && retryCount == 1) {
            this.eventPublisher.publish((Object)new TunnelErrorAnalyticsEvent(version, Response.Status.SERVICE_UNAVAILABLE.getStatusCode()));
        }
        if (TunnelProcessState.Status.RUNNING == newStatus) {
            if (TunnelProcessState.Status.RESTARTING == previousStatus) {
                this.eventPublisher.publish((Object)new TunnelReconnectedAnalyticsEvent(version));
            } else {
                this.eventPublisher.publish((Object)new TunnelConnectedAnalyticsEvent(version));
            }
        }
    }

    private Optional<String> getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin("com.atlassian.securetunnel.client.tunnel-client-plugin");
        if (plugin != null) {
            return Optional.of(plugin.getPluginInformation().getVersion());
        }
        return Optional.empty();
    }

    public TunnelConnectionEventListener(TunnelConnectionService tunnelConnectionService, EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.tunnelConnectionService = tunnelConnectionService;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }
}

