/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.audit;

import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.audit.AuditEvent;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.time.Clock;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;

public class LegacyBitbucketTunnelAuditService
implements TunnelAuditService {
    private final EventPublisher eventPublisher;
    private final I18nResolver i18nResolver;
    private final RequestManager requestManager;
    private final AuthenticationContext authenticationContext;
    private final Clock clock;

    @Override
    public void audit(String eventSummaryKey, String tunnelName) {
        AuditEntryBuilder auditEntry = new AuditEntryBuilder().action(this.i18nResolver.getText(eventSummaryKey)).timestamp(this.clock.millis()).target("Global");
        ImmutableMap.Builder auditEntryDetails = ImmutableMap.builder().put((Object)"tunnelName", (Object)tunnelName);
        this.ifPresent(this.requestManager.getRequestMetadata(), requestMetaData -> auditEntry.sourceIpAddress(requestMetaData.getRemoteAddress()));
        this.ifPresent(this.authenticationContext.getCurrentUser(), currentUser -> {
            auditEntryDetails.put((Object)"user", (Object)currentUser.getSlug());
            auditEntry.user(currentUser);
            auditEntry.target(currentUser.getSlug());
        });
        this.eventPublisher.publish((Object)new AuditEvent((Object)this, auditEntry.details(new Gson().toJson(auditEntryDetails.build())).build(), Collections.emptySet(), Priority.HIGH));
    }

    private <T> void ifPresent(T object, Consumer<T> func) {
        Optional.ofNullable(object).ifPresent(func);
    }

    public LegacyBitbucketTunnelAuditService(EventPublisher eventPublisher, I18nResolver i18nResolver, RequestManager requestManager, AuthenticationContext authenticationContext, Clock clock) {
        this.eventPublisher = eventPublisher;
        this.i18nResolver = i18nResolver;
        this.requestManager = requestManager;
        this.authenticationContext = authenticationContext;
        this.clock = clock;
    }
}

