/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.security;

import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public class DefaultConfidentialDataObfuscator
implements ConfidentialDataObfuscator {
    public static final String DEFAULT_REPLACEMENT_STRING = "******";
    private final TunnelService tunnelService;
    private final TunnelProperties tunnelProperties;

    @Override
    public void logError(Logger logger, String format, Object ... args) {
        if (logger.isErrorEnabled()) {
            logger.error(format, this.obfuscateArray(args));
        }
    }

    @Override
    public void logError(Logger logger, String message, Throwable exception) {
        if (logger.isErrorEnabled()) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            String stacktrace = stringWriter.toString();
            logger.error(String.format("%s: {}", this.obfuscate(message)), (Object)this.obfuscate(stacktrace));
        }
    }

    @Override
    public void logDebug(Logger logger, String format, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(format, this.obfuscateArray(args));
        }
    }

    private Object[] obfuscateArray(Object ... inputs) {
        return Arrays.stream(inputs).map(this::obfuscate).toArray();
    }

    private Object obfuscate(Object object) {
        return object == null ? null : this.obfuscate(object.toString());
    }

    public String obfuscate(String input) {
        if (input == null) {
            return null;
        }
        return this.getConfidentialTerms().stream().reduce(input, (obfuscatedInput, currentTerm) -> obfuscatedInput.replace((CharSequence)currentTerm, DEFAULT_REPLACEMENT_STRING));
    }

    private List<String> getConfidentialTerms() {
        ArrayList<String> terms = new ArrayList<String>();
        terms.add(this.tunnelProperties.getTunnelServiceUrl());
        this.extractHost(this.tunnelProperties.getTunnelServiceUrl()).ifPresent(terms::add);
        this.tunnelService.getTunnel().ifPresent(configuration -> {
            terms.add(configuration.getUpstreamDnsUrlAuthority());
            terms.add(configuration.getToken());
        });
        return Collections.unmodifiableList(terms);
    }

    private Optional<String> extractHost(String url) {
        try {
            URI uri = new URI(url);
            return Optional.of(uri.getHost());
        }
        catch (URISyntaxException exception) {
            return Optional.empty();
        }
    }

    public DefaultConfidentialDataObfuscator(TunnelService tunnelService, TunnelProperties tunnelProperties) {
        this.tunnelService = tunnelService;
        this.tunnelProperties = tunnelProperties;
    }
}

