/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.properties;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketTunnelProperties
extends DefaultTunnelProperties {
    private static final Logger log = LoggerFactory.getLogger(BitbucketTunnelProperties.class);
    static final String BITBUCKET_PLUGIN_PREFIX = "plugin.";
    private final ApplicationProperties applicationProperties;

    @Override
    public String getTunnelServiceUrl() {
        String tunnelServiceUrl = this.applicationProperties.getPropertyValue("plugin.secure.tunnel.service.endpoint");
        return tunnelServiceUrl != null && !tunnelServiceUrl.isEmpty() ? tunnelServiceUrl : super.getTunnelServiceUrl();
    }

    @Override
    public String getUpstreamHostUrl() {
        String upstreamPort = this.applicationProperties.getPropertyValue("plugin.secure.tunnel.upstream.port");
        log.trace("Found upstreamPort of {} ", (Object)upstreamPort);
        try {
            return this.formatUpstreamUrl(Integer.parseInt(upstreamPort));
        }
        catch (NumberFormatException exception) {
            return super.getUpstreamHostUrl();
        }
    }

    public BitbucketTunnelProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

