/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackoffHandler {
    private static final Logger log = LoggerFactory.getLogger(BackoffHandler.class);
    protected static final double RANDOMIZATION_FACTOR = 0.3;
    private static final long INITIAL_INTERVAL = 750L;
    private static final int MAX_RETRIES = 60;
    private static final int NO_WAIT_LIMIT = 5;

    private BackoffHandler() {
    }

    public static long determineWaitTime(int previousRetries) {
        int retryCount = Math.min(previousRetries, 60);
        if (retryCount <= 5) {
            return 0L;
        }
        long waitTime = 750L * (long)retryCount;
        long waitTimeIncludingJitter = BackoffHandler.applyJitter(waitTime);
        log.debug("Backoff wait time: {}", (Object)waitTimeIncludingJitter);
        return waitTimeIncludingJitter;
    }

    private static long applyJitter(long current) {
        long delta = (long)(0.3 * (double)current);
        return ThreadLocalRandom.current().nextLong(current - delta, current + delta);
    }
}

