/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.dao;

import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.dao.TunnelCipher;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingTunnelDao
implements TunnelDao {
    private static final Logger log = LoggerFactory.getLogger(EncryptingTunnelDao.class);
    private final TunnelDao delegate;
    private final TunnelCipher cipher;

    public EncryptingTunnelDao(TunnelDao delegate, TunnelCipher cipher) {
        this.delegate = delegate;
        this.cipher = cipher;
    }

    @Override
    public Optional<Tunnel> getTunnel() {
        return this.delegate.getTunnel().map(this::decrypt);
    }

    @Override
    public Tunnel saveTunnel(Tunnel tunnel) {
        this.deleteTunnelKey();
        return this.delegate.saveTunnel(this.encrypt(tunnel));
    }

    @Override
    public void deleteTunnel() {
        this.deleteTunnelKey();
        this.delegate.deleteTunnel();
    }

    @Override
    public void syncTunnel() {
        this.delegate.syncTunnel();
    }

    @Override
    public void reloadTunnelCaches() {
        this.delegate.reloadTunnelCaches();
    }

    private void deleteTunnelKey() {
        this.delegate.getTunnel().ifPresent(this::deleteTunnelKey);
    }

    private void deleteTunnelKey(Tunnel tunnel) {
        try {
            this.cipher.deleteKey(tunnel.getToken());
        }
        catch (Exception e) {
            log.warn("Could not delete token key", (Throwable)e);
        }
    }

    private Tunnel encrypt(Tunnel tunnel) {
        return tunnel.toBuilder().token(this.cipher.encrypt(tunnel.getToken())).build();
    }

    private Tunnel decrypt(Tunnel tunnel) {
        return tunnel.toBuilder().token(this.decrypt(tunnel.getToken())).build();
    }

    private String decrypt(String token) {
        try {
            return this.cipher.decrypt(token);
        }
        catch (Exception e) {
            log.error("Could not decrypt token", (Throwable)e);
            return token;
        }
    }
}

