/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import com.atlassian.tunnel.process.InletsClientManager;
import com.atlassian.tunnel.process.event.TunnelReloadedEvent;
import com.atlassian.tunnel.process.event.TunnelRoutingUnavailableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TunnelEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TunnelEventListener.class);
    private final InletsClientManager inletsClientManager;
    private final TunnelDao tunnelDao;
    private final EventPublisher eventPublisher;

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onTunnelReloadedEvent(TunnelReloadedEvent event) {
        log.trace("Received {}", (Object)event.getClass().getSimpleName());
        this.inletsClientManager.stop();
        this.inletsClientManager.start();
    }

    @EventListener
    public void onTunnelRoutingUnavailableEvent(TunnelRoutingUnavailableEvent event) {
        log.trace("Received {}", (Object)event.getClass().getSimpleName());
        this.tunnelDao.reloadTunnelCaches();
    }

    public TunnelEventListener(InletsClientManager inletsClientManager, TunnelDao tunnelDao, EventPublisher eventPublisher) {
        this.inletsClientManager = inletsClientManager;
        this.tunnelDao = tunnelDao;
        this.eventPublisher = eventPublisher;
    }
}

