/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.audit;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.audit.AuditRecord;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.google.common.base.Joiner;

public class LegacyConfluenceTunnelAuditService
implements TunnelAuditService {
    private final AuditService auditService;
    private final I18nResolver i18nResolver;
    private final I18NBeanFactory i18NBeanFactory;
    private final UserManager userManager;
    private final LocaleManager localeManager;

    @Override
    public void audit(String eventSummaryKey, String tunnelName) {
        String eventSummary = this.i18nResolver.getText(eventSummaryKey);
        String eventCategory = this.i18nResolver.getText("tunnel.client.audit.logging.general.configuration");
        AffectedObject affectedObject = new AffectedObject.Builder().name(tunnelName).objectType(eventCategory).build();
        I18NBean confluenceI18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getSiteDefaultLocale());
        this.auditService.storeRecord(new AuditRecord.Builder().category(eventCategory).summary(eventSummary).associatedObject(affectedObject).author(this.getAuthor(confluenceI18NBean)).remoteAddress(this.getRemoteAddress()).build());
    }

    private User getAuthor(I18NBean confluenceI18NBean) {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null) {
            return new User(null, user.getUsername(), user.getFullName(), user.getUserKey().getStringValue());
        }
        return this.systemUser(confluenceI18NBean);
    }

    private User systemUser(I18NBean confluenceI18NBean) {
        return new User(null, "", confluenceI18NBean.getText("system.name"), "");
    }

    private String getRemoteAddress() {
        String proxyAddresses = RequestCacheThreadLocal.getXForwardedFor();
        String remoteAddress = RequestCacheThreadLocal.getRemoteAddress();
        if (proxyAddresses == null) {
            return remoteAddress;
        }
        return Joiner.on((char)',').join((Object)proxyAddresses, (Object)remoteAddress, new Object[0]);
    }

    public LegacyConfluenceTunnelAuditService(AuditService auditService, I18nResolver i18nResolver, I18NBeanFactory i18NBeanFactory, UserManager userManager, LocaleManager localeManager) {
        this.auditService = auditService;
        this.i18nResolver = i18nResolver;
        this.i18NBeanFactory = i18NBeanFactory;
        this.userManager = userManager;
        this.localeManager = localeManager;
    }
}

