/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.audit.api.AuditService;
import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.tunnel.audit.DefaultTunnelAuditService;
import com.atlassian.tunnel.audit.LegacyConfluenceTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.DefaultNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.spring.product.ServiceCheckerUtil;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.SeraphRedirectsLoopPreventer;
import org.osgi.framework.BundleContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ConfluenceOnly.class})
public class ConfluenceConfiguration {
    @Bean
    public ClusterMonitoring clusterMonitoring() {
        return OsgiServices.importOsgiService(ClusterMonitoring.class);
    }

    @Bean
    public NodeIdProvider confluenceNodeIdProvider(ClusterMonitoring clusterMonitoring) {
        return new DefaultNodeIdProvider(clusterMonitoring);
    }

    @Bean
    public RedirectsLoopPreventer seraphRedirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public TunnelProperties tunnelProperties() {
        return new DefaultTunnelProperties();
    }

    @Bean
    public TunnelAuditService tunnelAuditService(I18nResolver i18nResolver, BundleContext bundleContext, UserManager userManager) {
        if (ServiceCheckerUtil.isAuditServiceAvailable(bundleContext)) {
            return new DefaultTunnelAuditService(OsgiServices.importOsgiService(AuditService.class), i18nResolver);
        }
        return new LegacyConfluenceTunnelAuditService(OsgiServices.importOsgiService(com.atlassian.confluence.api.service.audit.AuditService.class), i18nResolver, OsgiServices.importOsgiService(I18NBeanFactory.class), userManager, OsgiServices.importOsgiService(LocaleManager.class));
    }
}

