/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring;

import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.DevModeOnly;
import com.atlassian.tunnel.dev.DevConfidentialDataObfuscator;
import com.atlassian.tunnel.dev.DevInletsClientBootstrapService;
import com.atlassian.tunnel.dev.DevInletsClientBootstrapServiceImpl;
import com.atlassian.tunnel.dev.DevTunnelClientProcessService;
import com.atlassian.tunnel.dev.DevTunnelClientProcessServiceImpl;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.process.InletsClientManager;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@Conditional(value={DevModeOnly.class})
public class DevConfiguration {
    @Bean
    public DevInletsClientBootstrapService devInletsClientBootstrapService(InletsClientManager inletsClientManager) {
        return new DevInletsClientBootstrapServiceImpl(inletsClientManager);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportDevInletsClientBootstrapService(DevInletsClientBootstrapService devInletsClientBootstrapService) {
        return OsgiServices.exportOsgiService(devInletsClientBootstrapService, ExportOptions.as(DevInletsClientBootstrapService.class, new Class[0]));
    }

    @Bean
    public DevTunnelClientProcessService devTunnelClientProcessService(TunnelConnectionService tunnelConnectionService) {
        return new DevTunnelClientProcessServiceImpl(tunnelConnectionService);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportDevTunnelClientProcessService(DevTunnelClientProcessService devTunnelClientProcessService) {
        return OsgiServices.exportOsgiService(devTunnelClientProcessService, ExportOptions.as(DevTunnelClientProcessService.class, new Class[0]));
    }

    @Bean
    @Primary
    public ConfidentialDataObfuscator devConfidentialDataObfuscator() {
        return new DevConfidentialDataObfuscator();
    }
}

