/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InletsExecutable {
    private static final Logger log = LoggerFactory.getLogger(InletsExecutable.class);
    private static final String RESOURCES_BASE_PATH = "inlets-binaries";
    private final File file;

    protected InletsExecutable(Path workingDirectory, String executable) throws IOException {
        Path targetPath = Paths.get(workingDirectory.toString(), executable);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            this.extractFromResources(executable, targetPath);
        }
        this.file = new File(targetPath.toString());
        this.file.setExecutable(true);
    }

    public abstract String getCommand();

    public String getWorkingDirectory() {
        return this.file.getParent();
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.file.toPath());
        }
        catch (IOException exception) {
            log.warn("Could not delete Inlets binary from: {}", (Object)this.file.getAbsolutePath());
            log.debug("Exception: ", (Throwable)exception);
        }
    }

    private void extractFromResources(String filename, Path targetPath) throws IOException {
        block13: {
            String resourcePath = "inlets-binaries/" + filename;
            try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
                if (input != null) {
                    Files.copy(input, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    break block13;
                }
                throw new IOException("Could not find Inlets binary in resources. Path: " + resourcePath);
            }
        }
    }
}

