/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.cluster;

import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.cluster.monitoring.spi.model.NodeInformation;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class DefaultNodeIdProvider
implements NodeIdProvider {
    private final ClusterMonitoring clusterMonitoring;

    @Override
    public Optional<String> getLocalNodeId() {
        if (!this.clusterMonitoring.isAvailable()) {
            return Optional.empty();
        }
        return this.clusterMonitoring.getCurrentNode().map(NodeIdentifier::getNodeId).toOptional();
    }

    @Override
    public Set<String> getClusterNodeIds() {
        if (!this.clusterMonitoring.isAvailable()) {
            return Collections.emptySet();
        }
        return (Set)this.clusterMonitoring.getNodes().map(nodes -> nodes.stream().map(NodeInformation::getNodeId).collect(Collectors.toList())).map(nodeIds -> new HashSet(nodeIds)).getOrElse(Collections.emptySet());
    }

    public DefaultNodeIdProvider(ClusterMonitoring clusterMonitoring) {
        this.clusterMonitoring = clusterMonitoring;
    }
}

