/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.audit;

import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.TunnelAuditService;

public class CrowdTunnelAuditService
implements TunnelAuditService {
    private final AuditService crowdAuditService;
    private final I18nResolver i18nResolver;

    @Override
    public void audit(String eventSummaryKey, String tunnelName) {
        this.crowdAuditService.saveAudit(this.buildAuditLogChangeSet(eventSummaryKey, tunnelName));
    }

    private AuditLogChangeset buildAuditLogChangeSet(String eventSummaryKey, String tunnelName) {
        ImmutableAuditLogEntity tunnelEntity = new ImmutableAuditLogEntity.Builder().setPrimary().setEntityName(tunnelName).setEntityType(AuditLogEntityType.CONFIGURATION).build();
        return new ImmutableAuditLogChangeset.Builder().setEventType(AuditLogEventType.CONFIGURATION_MODIFIED).addEntity(tunnelEntity).setEventMessage(this.i18nResolver.getText(eventSummaryKey)).build();
    }

    public CrowdTunnelAuditService(AuditService crowdAuditService, I18nResolver i18nResolver) {
        this.crowdAuditService = crowdAuditService;
        this.i18nResolver = i18nResolver;
    }
}

