/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.audit.api.AuditService;
import com.atlassian.jira.auditing.AuditingService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.DefaultTunnelAuditService;
import com.atlassian.tunnel.audit.LegacyJiraTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.JiraNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.spring.product.ServiceCheckerUtil;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.SeraphRedirectsLoopPreventer;
import org.osgi.framework.BundleContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={JiraOnly.class})
public class JiraConfiguration {
    @Bean
    public ClusterManager clusterManager() {
        return OsgiServices.importOsgiService(ClusterManager.class);
    }

    @Bean
    public NodeIdProvider jiraNodeIdProvider(ClusterManager clusterManager) {
        return new JiraNodeIdProvider(clusterManager);
    }

    @Bean
    public RedirectsLoopPreventer seraphRedirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public TunnelProperties tunnelProperties() {
        return new DefaultTunnelProperties();
    }

    @Bean
    public TunnelAuditService tunnelAuditService(I18nResolver i18nResolver, BundleContext bundleContext) {
        if (ServiceCheckerUtil.isAuditServiceAvailable(bundleContext)) {
            return new DefaultTunnelAuditService(OsgiServices.importOsgiService(AuditService.class), i18nResolver);
        }
        return new LegacyJiraTunnelAuditService(OsgiServices.importOsgiService(AuditingService.class), i18nResolver);
    }
}

