/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

public final class TunnelProcessState {
    private final Status status;
    private final int retryCount;

    public static TunnelProcessState initial() {
        return new TunnelProcessState(Status.NOT_RUNNING, 0);
    }

    public TunnelProcessState incrementRetryCount() {
        return new TunnelProcessState(this.status, this.retryCount + 1);
    }

    public TunnelProcessState resetRetryCount() {
        return new TunnelProcessState(this.status, 0);
    }

    public TunnelProcessState(Status status, int retryCount) {
        this.status = status;
        this.retryCount = retryCount;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TunnelProcessState)) {
            return false;
        }
        TunnelProcessState other = (TunnelProcessState)o;
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCount();
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "TunnelProcessState(status=" + (Object)((Object)this.getStatus()) + ", retryCount=" + this.getRetryCount() + ")";
    }

    public TunnelProcessState withStatus(Status status) {
        return this.status == status ? this : new TunnelProcessState(status, this.retryCount);
    }

    public static enum Status {
        NOT_RUNNING,
        STARTING,
        RUNNING,
        RESTARTING,
        TERMINATING,
        AUTHENTICATION_FAILED;

    }
}

