/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process;

import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.configuration.exception.MissingTunnelException;
import com.atlassian.tunnel.file.InletsExecutable;
import com.atlassian.tunnel.process.InletsTokenFileManager;
import com.atlassian.tunnel.process.TunnelExecutorServiceProvider;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessMonitor;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InletsClientProcessFactory {
    private static final Logger log = LoggerFactory.getLogger(InletsClientProcessFactory.class);
    public static final long PROCESS_IDLE_TIMEOUT = Duration.of(100000L, ChronoUnit.DAYS).toMillis();
    private final ExternalProcessFactory externalProcessFactory;
    private final TunnelService tunnelService;
    private final TunnelProperties tunnelProperties;
    private final ConfidentialDataObfuscator confidentialDataObfuscator;
    private final InletsTokenFileManager inletsTokenFileManager;

    public InletsClientProcessFactory(TunnelExecutorServiceProvider tunnelExecutorServiceProvider, TunnelService tunnelService, TunnelProperties tunnelProperties, ConfidentialDataObfuscator confidentialDataObfuscator, InletsTokenFileManager inletsTokenFileManager) {
        this.externalProcessFactory = new DefaultExternalProcessFactory(tunnelExecutorServiceProvider.getExecutorService());
        this.tunnelService = tunnelService;
        this.tunnelProperties = tunnelProperties;
        this.confidentialDataObfuscator = confidentialDataObfuscator;
        this.inletsTokenFileManager = inletsTokenFileManager;
    }

    public ExternalProcess create(InletsExecutable executable, ProcessMonitor processMonitor, OutputHandler outputHandler) throws MissingTunnelException, IOException {
        Tunnel tunnelConfiguration = this.tunnelService.getTunnel().orElseThrow(MissingTunnelException::new);
        List<String> command = this.createClientCommand(executable.getCommand(), tunnelConfiguration);
        this.confidentialDataObfuscator.logDebug(log, "Creating process for executable {} with command {}", executable, command);
        ExternalProcessBuilder.setExternalProcessFactory(this.externalProcessFactory);
        return new ExternalProcessBuilder().asynchronous().command(command, new File(executable.getWorkingDirectory())).addMonitor(processMonitor).handlers(outputHandler, outputHandler).idleTimeout(PROCESS_IDLE_TIMEOUT).build();
    }

    private List<String> createClientCommand(String executableCommand, Tunnel tunnel) throws IOException {
        ArrayList<String> commandBuilder = new ArrayList<String>();
        commandBuilder.add(executableCommand);
        commandBuilder.add("client");
        commandBuilder.add("--url=" + this.tunnelProperties.getTunnelServiceUrl());
        commandBuilder.add("--upstream=" + tunnel.getUpstreamDnsUrlAuthority() + "=" + this.tunnelProperties.getUpstreamHostUrl());
        commandBuilder.add("--token-from=" + this.inletsTokenFileManager.writeTokenToFile(tunnel.getToken()));
        commandBuilder.add("--strict-forwarding");
        if (this.isInsecureConnection(this.tunnelProperties.getTunnelServiceUrl())) {
            commandBuilder.add("--insecure");
        }
        return Collections.unmodifiableList(commandBuilder);
    }

    private boolean isInsecureConnection(String url) {
        return url != null && url.startsWith("ws:");
    }
}

