/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration;

import com.atlassian.tunnel.configuration.exception.InvalidTunnelConfigurationException;
import com.atlassian.tunnel.rest.RestUtil;
import com.atlassian.tunnel.security.ConfidentialDataObfuscator;
import java.io.IOException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelConfigurationKeyDecoder {
    private static final Logger log = LoggerFactory.getLogger(TunnelConfigurationKeyDecoder.class);
    private final ConfidentialDataObfuscator confidentialDataObfuscator;

    public TunnelConfigurationKey decode(String key) {
        log.trace("Decoding Tunnel Configuration key");
        if (StringUtils.isBlank((CharSequence)key)) {
            log.error("Blank key provided when updating tunnel configuration");
            throw new InvalidTunnelConfigurationException(InvalidTunnelConfigurationException.Reason.EMPTY, "Tunnel Configuration key is empty");
        }
        try {
            byte[] decodedKey = Base64.getDecoder().decode(key);
            return (TunnelConfigurationKey)RestUtil.OBJECT_MAPPER.readValue(decodedKey, TunnelConfigurationKey.class);
        }
        catch (IOException | IllegalArgumentException exception) {
            this.confidentialDataObfuscator.logError(log, "Exception thrown when decoding/mapping tunnel configuration key: {}", exception.getMessage());
            throw new InvalidTunnelConfigurationException(InvalidTunnelConfigurationException.Reason.INVALID, "There was an error decoding/mapping Tunnel Configuration Key");
        }
    }

    public TunnelConfigurationKeyDecoder(ConfidentialDataObfuscator confidentialDataObfuscator) {
        this.confidentialDataObfuscator = confidentialDataObfuscator;
    }

    @JsonAutoDetect
    public static class TunnelConfigurationKey {
        private String name;
        private String cloudOrgName;
        private String cloudPageUrl;
        private String upstreamDnsUrl;
        private String token;

        public String getName() {
            return this.name;
        }

        public String getCloudOrgName() {
            return this.cloudOrgName;
        }

        public String getCloudPageUrl() {
            return this.cloudPageUrl;
        }

        public String getUpstreamDnsUrl() {
            return this.upstreamDnsUrl;
        }

        public String getToken() {
            return this.token;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCloudOrgName(String cloudOrgName) {
            this.cloudOrgName = cloudOrgName;
        }

        public void setCloudPageUrl(String cloudPageUrl) {
            this.cloudPageUrl = cloudPageUrl;
        }

        public void setUpstreamDnsUrl(String upstreamDnsUrl) {
            this.upstreamDnsUrl = upstreamDnsUrl;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TunnelConfigurationKey)) {
                return false;
            }
            TunnelConfigurationKey other = (TunnelConfigurationKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$cloudOrgName = this.getCloudOrgName();
            String other$cloudOrgName = other.getCloudOrgName();
            if (this$cloudOrgName == null ? other$cloudOrgName != null : !this$cloudOrgName.equals(other$cloudOrgName)) {
                return false;
            }
            String this$cloudPageUrl = this.getCloudPageUrl();
            String other$cloudPageUrl = other.getCloudPageUrl();
            if (this$cloudPageUrl == null ? other$cloudPageUrl != null : !this$cloudPageUrl.equals(other$cloudPageUrl)) {
                return false;
            }
            String this$upstreamDnsUrl = this.getUpstreamDnsUrl();
            String other$upstreamDnsUrl = other.getUpstreamDnsUrl();
            if (this$upstreamDnsUrl == null ? other$upstreamDnsUrl != null : !this$upstreamDnsUrl.equals(other$upstreamDnsUrl)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TunnelConfigurationKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $cloudOrgName = this.getCloudOrgName();
            result = result * 59 + ($cloudOrgName == null ? 43 : $cloudOrgName.hashCode());
            String $cloudPageUrl = this.getCloudPageUrl();
            result = result * 59 + ($cloudPageUrl == null ? 43 : $cloudPageUrl.hashCode());
            String $upstreamDnsUrl = this.getUpstreamDnsUrl();
            result = result * 59 + ($upstreamDnsUrl == null ? 43 : $upstreamDnsUrl.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        public String toString() {
            return "TunnelConfigurationKeyDecoder.TunnelConfigurationKey(name=" + this.getName() + ", cloudOrgName=" + this.getCloudOrgName() + ", cloudPageUrl=" + this.getCloudPageUrl() + ", upstreamDnsUrl=" + this.getUpstreamDnsUrl() + ", token=" + this.getToken() + ")";
        }

        public TunnelConfigurationKey() {
        }

        public TunnelConfigurationKey(String name, String cloudOrgName, String cloudPageUrl, String upstreamDnsUrl, String token) {
            this.name = name;
            this.cloudOrgName = cloudOrgName;
            this.cloudPageUrl = cloudPageUrl;
            this.upstreamDnsUrl = upstreamDnsUrl;
            this.token = token;
        }
    }
}

