/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform;

import com.atlassian.plugins.authentication.sso.config.CachingSsoConfigService;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.DisableNativeLoginAuthFilter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginAuthResponseWriter;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class JsmAwareDisableNativeLoginAuthFilter
extends DisableNativeLoginAuthFilter {
    @Inject
    public JsmAwareDisableNativeLoginAuthFilter(DisableNativeLoginAuthResponseWriter disableBasicAuthResponseWriter, List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks, CachingSsoConfigService cachingSsoConfigService) {
        super(disableBasicAuthResponseWriter, blockRequestChecks, cachingSsoConfigService);
    }

    @Override
    protected boolean shouldBlock(HttpServletRequest request) {
        return this.isLoginToJsm(request) ? this.isBlocked(request) : super.shouldBlock(request);
    }

    private boolean isBlocked(HttpServletRequest request) {
        return !this.isNativeLoginEnabledForJsm() && this.isNativeAuthenticationRequest(request);
    }

    private boolean isNativeLoginEnabledForJsm() {
        return this.cachingSsoConfigService.getSsoConfig().getShowLoginFormForJsm() || this.cachingSsoConfigService.getSsoConfig().enableAuthenticationFallback();
    }

    private boolean isLoginToJsm(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return (servletPath.startsWith("/servicedesk/customer") || servletPath.startsWith("/rest/servicedesk")) && servletPath.endsWith("/user/login");
    }
}

