/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.usercontext.impl.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.SalPrincipalResolver;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@BitbucketComponent
@StashComponent
@ConfluenceComponent
@FecruComponent
public class EmbeddedCrowdPrincipalResolver
extends SalPrincipalResolver {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCrowdPrincipalResolver.class);
    private final CrowdService crowdService;
    private final DarkFeatureManager darkFeatureManager;
    protected static final String EXTERNAL_DIRECTORY_FAILURE_HANDLING_FEATURE_KEY = "atlassian.authentication.sso.fallback.to.cached.user.when.operation.failed";

    @Inject
    public EmbeddedCrowdPrincipalResolver(@ComponentImport UserManager userManager, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdService crowdService, @ComponentImport DarkFeatureManager darkFeatureManager) {
        super(userManager, authenticationController);
        this.crowdService = crowdService;
        this.darkFeatureManager = darkFeatureManager;
    }

    private boolean isUserActiveInSynchronizedDirectory(String username) {
        return Optional.ofNullable(this.crowdService.getUser(username)).map(User::isActive).orElse(false);
    }

    private boolean isUserEligibleForApplicationFallback(String username) {
        return this.darkFeatureManager.isEnabledForAllUsers(EXTERNAL_DIRECTORY_FAILURE_HANDLING_FEATURE_KEY).orElse(false) != false && this.isUserActiveInSynchronizedDirectory(username);
    }

    @Override
    public Optional<Principal> resolvePrincipal(String username, HttpServletRequest request) {
        try {
            this.crowdService.userAuthenticated(username);
            return Optional.ofNullable(this.userManager.resolve(username));
        }
        catch (OperationFailedException e) {
            if (this.isUserEligibleForApplicationFallback(username)) {
                log.warn("Fetched state for user '{}' from the application database because the external directory is down.", (Object)username);
                return Optional.ofNullable(this.userManager.resolve(username));
            }
            throw new AuthenticationFailedException("Error authenticating user", e);
        }
        catch (InactiveAccountException | UserNotFoundException e) {
            log.debug("Exception caught when looking for user, treating user as not found", e);
            return Optional.empty();
        }
    }
}

