/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.loginform;

import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.impl.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.impl.web.filter.AbstractJohnsonAwareFilter;
import com.atlassian.plugins.authentication.impl.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import com.atlassian.plugins.authentication.impl.web.filter.loginform.writer.DisableNativeLoginAuthResponseWriter;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableNativeLoginAuthFilter
extends AbstractJohnsonAwareFilter {
    private static final Logger log = LoggerFactory.getLogger(DisableNativeLoginAuthFilter.class);
    private final DisableNativeLoginAuthResponseWriter responseWriter;
    private final List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks;
    protected final SsoConfigCachingService ssoConfigCachingService;

    @Inject
    public DisableNativeLoginAuthFilter(JohnsonChecker johnsonChecker, DisableNativeLoginAuthResponseWriter disableBasicAuthResponseWriter, List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks, SsoConfigCachingService ssoConfigCachingService) {
        super(johnsonChecker);
        this.responseWriter = disableBasicAuthResponseWriter;
        this.blockRequestChecks = blockRequestChecks;
        this.ssoConfigCachingService = ssoConfigCachingService;
    }

    @Override
    public void doFilterInternal(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Result result;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Result result2 = result = this.shouldBlock(request) ? Result.BLOCK_REQUEST : Result.ALLOW_REQUEST;
        if (result == Result.BLOCK_REQUEST) {
            log.trace("Blocking HTTP request - Native Login is not allowed: {}", (Object)request.getRequestURI());
            this.responseWriter.write(request, response);
        } else {
            log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean shouldBlock(HttpServletRequest request) {
        return !this.isNativeLoginEnabled() && this.isNativeAuthenticationRequest(request);
    }

    protected boolean isNativeAuthenticationRequest(HttpServletRequest request) {
        return this.blockRequestChecks.stream().anyMatch(check -> check.test(request));
    }

    private boolean isNativeLoginEnabled() {
        return this.ssoConfigCachingService.get().getShowLoginForm() || this.ssoConfigCachingService.get().enableAuthenticationFallback();
    }

    private static enum Result {
        BLOCK_REQUEST,
        ALLOW_REQUEST;

    }
}

