/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.basicauth.filter;

import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.impl.basicauth.filter.DisableBasicAuthResponseWriter;
import com.atlassian.plugins.authentication.impl.basicauth.service.BasicAuthRequestMatcher;
import com.atlassian.plugins.authentication.impl.basicauth.service.CachingBasicAuthService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Base64;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public class DisableBasicAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DisableBasicAuthFilter.class);
    @VisibleForTesting
    static final String INVALIDATE_SESSION_SYSTEM_PROPERTY = "com.atlassian.plugins.authentication.basic.auth.filter.invalidate.session";
    private static final String BASIC_AUTH_TYPE_PREFIX = "Basic ";
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private final CachingBasicAuthService cachingBasicAuthService;
    private final DisableBasicAuthResponseWriter disableBasicAuthResponseWriter;
    private final SsoConfigCachingService ssoConfigCachingService;

    @Inject
    public DisableBasicAuthFilter(CachingBasicAuthService cachingBasicAuthService, DisableBasicAuthResponseWriter disableBasicAuthResponseWriter, SsoConfigCachingService ssoConfigCachingService) {
        this.cachingBasicAuthService = cachingBasicAuthService;
        this.disableBasicAuthResponseWriter = disableBasicAuthResponseWriter;
        this.ssoConfigCachingService = ssoConfigCachingService;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        Result result = this.checkRequest(request);
        if (result == Result.BLOCK_REQUEST) {
            log.trace("Blocking HTTP request - Basic Authentication is not allowed: {}", (Object)request.getRequestURI());
            this.disableBasicAuthResponseWriter.write(request, response);
        } else {
            log.trace("Allowing HTTP request: {}", (Object)request.getRequestURI());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (result == Result.INVALIDATE_SESSION && !"false".equalsIgnoreCase(System.getProperty(INVALIDATE_SESSION_SYSTEM_PROPERTY))) {
                this.invalidateSession(request);
            }
        }
    }

    private void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                log.debug("Invalidating session {} for HTTP request: {}", (Object)session.getId(), (Object)request.getRequestURI());
                session.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private boolean isNativeLoginEnabled() {
        return this.ssoConfigCachingService.get().getShowLoginForm() || this.ssoConfigCachingService.get().enableAuthenticationFallback();
    }

    private Result invalidateSessionIfNativeLoginDisabled() {
        if (!this.isNativeLoginEnabled()) {
            log.debug("Session for Basic Authentication will be invalidated because login form is disabled");
            return Result.INVALIDATE_SESSION;
        }
        return Result.ALLOW_REQUEST;
    }

    private Result checkRequest(HttpServletRequest request) {
        String authorizationHeader = StringUtils.trim((String)request.getHeader("Authorization"));
        BasicAuthRequestMatcher matcher = this.cachingBasicAuthService.getMatcher();
        if (this.isBasicAuthorizationHeader(authorizationHeader)) {
            if (matcher.isBlockRequests()) {
                String path = URL_PATH_HELPER.getPathWithinApplication(request);
                String user = this.decodeBasicAuthorizationUsername(authorizationHeader);
                log.debug("Basic Authentication is not allowed, checking if request is allow-listed (path={}, user={})", (Object)path, (Object)user);
                if (matcher.isPathAllowed(path)) {
                    log.debug("Path is allowed - allowing the request, but will invalidate session afterwards (path={}, user={})", (Object)path, (Object)user);
                    return Result.INVALIDATE_SESSION;
                }
                if (matcher.isUserAllowed(user)) {
                    log.debug("User is allowed - allowing the request (path={}, user={})", (Object)path, (Object)user);
                    return this.invalidateSessionIfNativeLoginDisabled();
                }
                log.debug("Neither path nor user are allowed - blocking the request (path={}, user={})", (Object)path, (Object)user);
                return Result.BLOCK_REQUEST;
            }
            return this.invalidateSessionIfNativeLoginDisabled();
        }
        return Result.ALLOW_REQUEST;
    }

    private boolean isBasicAuthorizationHeader(@Nullable String header) {
        return StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)BASIC_AUTH_TYPE_PREFIX);
    }

    @Nullable
    private String decodeBasicAuthorizationUsername(@Nullable String authHeader) {
        try {
            String encodedCredentials = StringUtils.substring((String)authHeader, (int)BASIC_AUTH_TYPE_PREFIX.length());
            String decodedCredentials = new String(Base64.getDecoder().decode(encodedCredentials));
            return StringUtils.substringBefore((String)decodedCredentials, (String)":");
        }
        catch (IllegalArgumentException e) {
            log.debug("Could not decode Authorisation header - not a base64 encoded value", (Throwable)e);
            return null;
        }
    }

    public void destroy() {
    }

    private static enum Result {
        BLOCK_REQUEST,
        INVALIDATE_SESSION,
        ALLOW_REQUEST;

    }
}

