/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCheckPomPhase
extends AbstractReleasePhase {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;
    private final boolean scmRequired;
    private final boolean snapshotsRequired;

    public AbstractCheckPomPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, boolean scmRequired, boolean snapshotsRequired) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
        this.scmRequired = scmRequired;
        this.snapshotsRequired = snapshotsRequired;
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (this.scmRequired) {
            if (StringUtils.isEmpty((String)releaseDescriptor.getScmSourceUrl())) {
                throw new ReleaseFailureException("Missing required setting: scm connection or developerConnection must be specified.");
            }
            try {
                this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            }
            catch (ScmRepositoryException e) {
                throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
            }
            catch (NoSuchScmProviderException e) {
                throw new ReleaseFailureException("The provider given in the SCM URL could not be found: " + e.getMessage());
            }
        }
        boolean containsSnapshotProjects = false;
        for (MavenProject project : reactorProjects) {
            if (!ArtifactUtils.isSnapshot((String)project.getVersion())) continue;
            containsSnapshotProjects = true;
            break;
        }
        if (this.snapshotsRequired && !containsSnapshotProjects && !releaseDescriptor.isBranchCreation()) {
            throw new ReleaseFailureException("You don't have a SNAPSHOT project in the reactor projects list.");
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }
}

