/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.AbstractMavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.MavenCrypto;
import org.slf4j.Logger;

@Singleton
@Named(value="invoker")
public class InvokerMavenExecutor
extends AbstractMavenExecutor {
    @Inject
    public InvokerMavenExecutor(MavenCrypto mavenCrypto) {
        super(mavenCrypto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeGoals(File workingDirectory, List<String> goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        InvokerLogger bridge = this.getInvokerLogger();
        Invoker invoker = new DefaultInvoker().setMavenHome(releaseEnvironment.getMavenHome()).setLocalRepositoryDirectory(releaseEnvironment.getLocalRepositoryDirectory()).setLogger(bridge);
        InvocationRequest req = new DefaultInvocationRequest().setDebug(this.getLogger().isDebugEnabled()).setBaseDirectory(workingDirectory).setBatchMode(!interactive).setJavaHome(releaseEnvironment.getJavaHome()).setOutputHandler(arg_0 -> ((Logger)this.getLogger()).info(arg_0)).setErrorHandler(arg_0 -> ((Logger)this.getLogger()).error(arg_0));
        if (interactive) {
            req.setInputStream(System.in);
        }
        if (pomFileName != null) {
            req.setPomFileName(pomFileName);
        }
        File settingsFile = null;
        if (releaseEnvironment.getSettings() != null) {
            try {
                settingsFile = Files.createTempFile("release-settings", ".xml", new FileAttribute[0]).toFile();
                SettingsXpp3Writer writer = this.getSettingsWriter();
                try (FileWriter fileWriter = new FileWriter(settingsFile);){
                    writer.write((Writer)fileWriter, this.encryptSettings(releaseEnvironment.getSettings()));
                }
                req.setUserSettingsFile(settingsFile);
            }
            catch (IOException e) {
                throw new MavenExecutorException("Could not create temporary file for release settings.xml", e);
            }
        }
        try {
            ArrayList<String> targetGoals = new ArrayList<String>(goals);
            if (additionalArguments != null && !additionalArguments.isEmpty()) {
                targetGoals.add(additionalArguments);
            }
            req.setGoals(targetGoals);
            try {
                InvocationResult invocationResult = invoker.execute(req);
                if (invocationResult.getExecutionException() != null) {
                    throw new MavenExecutorException("Error executing Maven.", invocationResult.getExecutionException());
                }
                if (invocationResult.getExitCode() != 0) {
                    throw new MavenExecutorException("Maven execution failed, exit code: " + invocationResult.getExitCode(), invocationResult.getExitCode());
                }
            }
            catch (MavenInvocationException e) {
                throw new MavenExecutorException("Failed to invoke Maven build.", e);
            }
        }
        finally {
            if (settingsFile != null && settingsFile.exists() && !settingsFile.delete()) {
                settingsFile.deleteOnExit();
            }
        }
    }

    protected InvokerLogger getInvokerLogger() {
        return new LoggerBridge(this.getLogger());
    }

    private static final class LoggerBridge
    implements InvokerLogger {
        private final Logger logger;

        LoggerBridge(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void debug(String message, Throwable error) {
            this.logger.debug(message, error);
        }

        @Override
        public void debug(String message) {
            this.logger.debug(message);
        }

        @Override
        public void error(String message, Throwable error) {
            this.logger.error(message, error);
        }

        @Override
        public void error(String message) {
            this.logger.error(message);
        }

        @Override
        public void fatalError(String message, Throwable error) {
            this.logger.error(message, error);
        }

        @Override
        public void fatalError(String message) {
            this.logger.error(message);
        }

        @Override
        public int getThreshold() {
            return 4;
        }

        @Override
        public void info(String message, Throwable error) {
            this.logger.info(message, error);
        }

        @Override
        public void info(String message) {
            this.logger.info(message);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isFatalErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void setThreshold(int level) {
        }

        @Override
        public void warn(String message, Throwable error) {
            this.logger.warn(message, error);
        }

        @Override
        public void warn(String message) {
            this.logger.warn(message);
        }
    }
}

