/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.executor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import com.atlassian.bamboo.plugins.variable.updater.task.executor.VersionVariableTask;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AdvanceVersionVariableTask
extends VersionVariableTask {
    public static final String VERSION_PATTERN_TO_MATCH_CONFIG_KEY = "versionPattern";
    public static final String UPDATE_STRATEGY_CONFIG_KEY = "strategy";

    @Override
    @NotNull
    public TaskResult executeTask(@NotNull CommonTaskContext taskContext) throws TaskException {
        ResultKey resultKey;
        String planKeyOrEnvironmentId;
        String variableName = (String)taskContext.getConfigurationMap().get((Object)"variable");
        String variableValueRegex = (String)taskContext.getConfigurationMap().get((Object)VERSION_PATTERN_TO_MATCH_CONFIG_KEY);
        VariableUpdater.Scope variableScope = VariableUpdater.Scope.valueOf(((String)taskContext.getConfigurationMap().get((Object)"variableScope")).toUpperCase());
        boolean includeGlobals = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"includeGlobals"));
        boolean useBranchVariables = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"branchVars"));
        VariableContext variableContext = taskContext.getCommonContext().getVariableContext();
        VariableType variableType = variableContext.getEffectiveVariables().get(variableName) == null ? VariableType.UNKNOWN : ((VariableDefinitionContext)variableContext.getEffectiveVariables().get(variableName)).getVariableType();
        boolean keepCustomised = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"overrideCustomised"));
        if (keepCustomised && variableType == VariableType.MANUAL) {
            return this.skipUpdatingIfConflictWithCustomVariables(taskContext, variableName);
        }
        VariableUpdater.IncrementStrategy strategy = VariableUpdater.IncrementStrategy.valueOf(((String)taskContext.getConfigurationMap().get((Object)UPDATE_STRATEGY_CONFIG_KEY)).toUpperCase());
        if (taskContext instanceof DeploymentTaskContext) {
            DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)taskContext;
            long deploymentEnvironmentId = deploymentTaskContext.getDeploymentContext().getEnvironmentId();
            planKeyOrEnvironmentId = String.valueOf(deploymentEnvironmentId);
            resultKey = deploymentTaskContext.getDeploymentContext().getResultKey();
        } else if (taskContext instanceof TaskContext) {
            TaskContext tContext = (TaskContext)taskContext;
            planKeyOrEnvironmentId = tContext.getBuildContext().getParentBuildContext().getPlanKey();
            resultKey = tContext.getBuildContext().getResultKey();
        } else {
            throw new TaskException("TaskContext not defined: " + taskContext.getClass().getName());
        }
        Map buildCustomVariables = taskContext.getCommonContext().getCurrentResult().getCustomBuildData();
        String currentValue = this.retrieveCurrentValue(variableName, buildCustomVariables, variableContext, taskContext.getBuildLogger());
        VariableUpdater updater = new VariableUpdater(resultKey, taskContext.getWorkingDirectory().getAbsolutePath(), buildCustomVariables);
        updater.update(planKeyOrEnvironmentId, variableName, currentValue, variableValueRegex, includeGlobals, variableScope, strategy, this.isRemote(), taskContext.getBuildLogger(), variableContext, useBranchVariables);
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }
}

