/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.variable.updater.task.configuration.VersionVariableTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyVariableTaskConfigurator
extends VersionVariableTaskConfigurator {
    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("originVariable", params.getString("originVariable"));
        return config;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("originVariable", "");
        this.populateLists(context);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("originVariable", taskDefinition.getConfiguration().get("originVariable"));
        this.populateLists(context);
    }

    @Override
    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("originVariable", taskDefinition.getConfiguration().get("originVariable"));
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (params.getString("originVariable") == null || params.getString("originVariable").isEmpty()) {
            errorCollection.addError("originVariable", this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.empty.error"));
        }
    }
}

