/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import com.atlassian.bamboo.plugins.variable.updater.task.configuration.VersionVariableTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvanceVersionVariableTaskConfigurator
extends VersionVariableTaskConfigurator {
    @Override
    void populateLists(@NotNull Map<String, Object> context) {
        super.populateLists(context);
        ImmutableMap strategyOptions = new ImmutableMap.Builder().put((Object)VariableUpdater.IncrementStrategy.REGEX.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.value.regex")).put((Object)VariableUpdater.IncrementStrategy.MAVENRELEASE.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.value.maven.release")).put((Object)VariableUpdater.IncrementStrategy.DEPLOYMENT.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.value.bamboo.release")).build();
        context.put("strategyOptions", strategyOptions);
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("versionPattern", params.getString("versionPattern"));
        config.put("strategy", params.getString("strategy"));
        return config;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("versionPattern", "");
        context.put("strategy", (Object)VariableUpdater.IncrementStrategy.MAVENRELEASE);
        this.populateLists(context);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("versionPattern", taskDefinition.getConfiguration().get("versionPattern"));
        context.put("strategy", taskDefinition.getConfiguration().get("strategy"));
        this.populateLists(context);
    }

    @Override
    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("versionPattern", taskDefinition.getConfiguration().get("versionPattern"));
        context.put("strategy", taskDefinition.getConfiguration().get("strategy"));
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (!StringUtils.isBlank((String)params.getString("versionPattern"))) {
            try {
                Pattern.compile(params.getString("versionPattern"));
            }
            catch (Exception e) {
                errorCollection.addError("versionPattern", this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.value.invalid.error"));
            }
        }
    }
}

