/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater;

import com.atlassian.bamboo.build.logger.BuildLogger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomReader {
    private final Model model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(@NotNull BuildLogger buildLogger, @NotNull File buildDirectory, @Nullable String pomFile) throws IOException, XmlPullParserException {
        InputStreamReader reader = null;
        try {
            reader = pomFile != null && !pomFile.isEmpty() ? new FileReader(new File(buildDirectory, pomFile)) : new FileReader(new File(buildDirectory, "pom.xml"));
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            this.model = mavenreader.read((Reader)reader);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    buildLogger.addErrorLogEntry("help", (Throwable)e);
                }
            }
        }
    }

    public String retrieveValue() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String version = (String)PropertyUtils.getProperty((Object)this.model, (String)"version");
        if (version != null) {
            return version;
        }
        String parent = (String)PropertyUtils.getProperty((Object)this.model, (String)"parent.version");
        if (parent != null) {
            return parent;
        }
        throw new IllegalArgumentException("Pom file does not have a valid version");
    }
}

